/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import io.atomix.core.map.AtomicMap;
import io.atomix.core.map.AtomicMapBuilder;
import io.atomix.core.map.AtomicMapConfig;
import io.atomix.core.map.AtomicMapType;
import io.atomix.core.transaction.TransactionParticipant;
import io.atomix.core.transaction.TransactionalMap;
import io.atomix.core.transaction.TransactionalMapBuilder;
import io.atomix.core.transaction.TransactionalMapConfig;
import io.atomix.core.transaction.impl.DefaultTransaction;
import io.atomix.core.transaction.impl.ReadCommittedTransactionalMap;
import io.atomix.core.transaction.impl.RepeatableReadsTransactionalMap;
import io.atomix.core.transaction.impl.SingletonTransactionalMap;
import io.atomix.core.transaction.impl.TransactionalMapParticipant;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public class DefaultTransactionalMapBuilder<K, V>
extends TransactionalMapBuilder<K, V> {
    private final AtomicMapBuilder<K, V> mapBuilder;
    private final DefaultTransaction transaction;

    public DefaultTransactionalMapBuilder(String name, TransactionalMapConfig config, PrimitiveManagementService managementService, DefaultTransaction transaction) {
        super(name, config, managementService);
        this.mapBuilder = AtomicMapType.instance().newBuilder(name, new AtomicMapConfig(), managementService);
        this.transaction = transaction;
    }

    @Override
    public TransactionalMapBuilder<K, V> withProtocol(ProxyProtocol protocol) {
        this.mapBuilder.withProtocol(protocol);
        return this;
    }

    public TransactionalMapBuilder<K, V> withSerializer(Serializer serializer) {
        this.mapBuilder.withSerializer(serializer);
        return this;
    }

    public CompletableFuture<TransactionalMap<K, V>> getAsync() {
        return this.buildMap(() -> this.mapBuilder.getAsync(), SingletonTransactionalMap::new);
    }

    public CompletableFuture<TransactionalMap<K, V>> buildAsync() {
        return this.buildMap(() -> this.mapBuilder.buildAsync(), m -> m);
    }

    private CompletableFuture<TransactionalMap<K, V>> buildMap(Supplier<CompletableFuture<AtomicMap<K, V>>> mapSupplier, Function<TransactionalMapParticipant<K, V>, TransactionParticipant<?>> mapWrapper) {
        return mapSupplier.get().thenApply(map -> {
            TransactionalMapParticipant transactionalMap;
            switch (this.transaction.isolation()) {
                case READ_COMMITTED: {
                    transactionalMap = new ReadCommittedTransactionalMap(this.transaction.transactionId(), map.async());
                    break;
                }
                case REPEATABLE_READS: {
                    transactionalMap = new RepeatableReadsTransactionalMap(this.transaction.transactionId(), map.async());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.transaction.addParticipants((TransactionParticipant)mapWrapper.apply(transactionalMap));
            return transactionalMap.sync();
        });
    }
}

