/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import io.atomix.core.set.DistributedSet;
import io.atomix.core.set.DistributedSetBuilder;
import io.atomix.core.set.DistributedSetConfig;
import io.atomix.core.set.DistributedSetType;
import io.atomix.core.transaction.TransactionParticipant;
import io.atomix.core.transaction.TransactionalSet;
import io.atomix.core.transaction.TransactionalSetBuilder;
import io.atomix.core.transaction.TransactionalSetConfig;
import io.atomix.core.transaction.impl.DefaultTransaction;
import io.atomix.core.transaction.impl.ReadCommittedTransactionalSet;
import io.atomix.core.transaction.impl.RepeatableReadsTransactionalSet;
import io.atomix.core.transaction.impl.SingletonTransactionalSet;
import io.atomix.core.transaction.impl.TransactionalSetParticipant;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public class DefaultTransactionalSetBuilder<E>
extends TransactionalSetBuilder<E> {
    private final DistributedSetBuilder<E> setBuilder;
    private final DefaultTransaction transaction;

    public DefaultTransactionalSetBuilder(String name, TransactionalSetConfig config, PrimitiveManagementService managementService, DefaultTransaction transaction) {
        super(name, config, managementService);
        this.setBuilder = DistributedSetType.instance().newBuilder(name, new DistributedSetConfig(), managementService);
        this.transaction = transaction;
    }

    @Override
    public TransactionalSetBuilder<E> withProtocol(ProxyProtocol protocol) {
        this.setBuilder.withProtocol(protocol);
        return this;
    }

    public TransactionalSetBuilder<E> withSerializer(Serializer serializer) {
        this.setBuilder.withSerializer(serializer);
        return this;
    }

    public CompletableFuture<TransactionalSet<E>> getAsync() {
        return this.buildSet(() -> this.setBuilder.getAsync(), SingletonTransactionalSet::new);
    }

    public CompletableFuture<TransactionalSet<E>> buildAsync() {
        return this.buildSet(() -> this.setBuilder.buildAsync(), s -> s);
    }

    private CompletableFuture<TransactionalSet<E>> buildSet(Supplier<CompletableFuture<DistributedSet<E>>> setSupplier, Function<TransactionalSetParticipant<E>, TransactionParticipant<?>> setWrapper) {
        return setSupplier.get().thenApply(set -> {
            TransactionalSetParticipant transactionalSet;
            switch (this.transaction.isolation()) {
                case READ_COMMITTED: {
                    transactionalSet = new ReadCommittedTransactionalSet(this.transaction.transactionId(), set.async());
                    break;
                }
                case REPEATABLE_READS: {
                    transactionalSet = new RepeatableReadsTransactionalSet(this.transaction.transactionId(), set.async());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.transaction.addParticipants((TransactionParticipant)setWrapper.apply(transactionalSet));
            return transactionalSet.sync();
        });
    }
}

