/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import io.atomix.core.transaction.AsyncTransactionalSet;
import io.atomix.core.transaction.TransactionalSet;
import io.atomix.core.transaction.impl.BlockingTransactionalSet;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.ProxyProtocol;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class DelegatingTransactionalSet<E>
implements AsyncTransactionalSet<E> {
    private final AsyncTransactionalSet<E> set;

    public DelegatingTransactionalSet(AsyncTransactionalSet<E> set) {
        this.set = set;
    }

    public String name() {
        return this.set.name();
    }

    public PrimitiveType type() {
        return this.set.type();
    }

    public ProxyProtocol protocol() {
        return (ProxyProtocol)this.set.protocol();
    }

    @Override
    public CompletableFuture<Boolean> add(E e) {
        return this.set.add(e);
    }

    @Override
    public CompletableFuture<Boolean> remove(E e) {
        return this.set.remove(e);
    }

    @Override
    public CompletableFuture<Boolean> contains(E e) {
        return this.set.contains(e);
    }

    public CompletableFuture<Void> close() {
        return this.set.close();
    }

    public CompletableFuture<Void> delete() {
        return this.set.delete();
    }

    @Override
    public TransactionalSet<E> sync(Duration operationTimeout) {
        return new BlockingTransactionalSet<E>(this.set, operationTimeout.toMillis());
    }
}

