/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.transaction.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atomix.core.map.AsyncAtomicMap;
import io.atomix.core.map.impl.MapUpdate;
import io.atomix.core.transaction.TransactionId;
import io.atomix.core.transaction.TransactionLog;
import io.atomix.core.transaction.impl.TransactionalMapParticipant;
import io.atomix.primitive.protocol.ProxyProtocol;
import io.atomix.utils.time.Versioned;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class ReadCommittedTransactionalMap<K, V>
extends TransactionalMapParticipant<K, V> {
    private final Map<K, MapUpdate<K, V>> updates = Maps.newConcurrentMap();

    public ReadCommittedTransactionalMap(TransactionId transactionId, AsyncAtomicMap<K, V> consistentMap) {
        super(transactionId, consistentMap);
    }

    @Override
    public ProxyProtocol protocol() {
        return (ProxyProtocol)this.consistentMap.protocol();
    }

    @Override
    public CompletableFuture<V> get(K key) {
        return this.consistentMap.get(key).thenApply(Versioned::valueOrNull);
    }

    @Override
    public CompletableFuture<Boolean> containsKey(K key) {
        return this.consistentMap.get(key).thenApply(Objects::nonNull);
    }

    @Override
    public CompletableFuture<V> put(K key, V value) {
        return this.consistentMap.get(key).thenApply(versioned -> {
            if (versioned == null) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_ABSENT).withKey(key).withValue(value).build());
                return null;
            }
            this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey(key).withValue(value).withVersion(versioned.version()).build());
            return versioned.value();
        });
    }

    @Override
    public CompletableFuture<V> putIfAbsent(K key, V value) {
        return this.consistentMap.get(key).thenApply(versioned -> {
            if (versioned == null) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_ABSENT).withKey(key).withValue(value).build());
                return null;
            }
            return versioned.value();
        });
    }

    @Override
    public CompletableFuture<V> remove(K key) {
        return this.consistentMap.get(key).thenApply(versioned -> {
            if (versioned != null) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey(key).withVersion(versioned.version()).build());
                return versioned.value();
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Boolean> remove(K key, V value) {
        return this.consistentMap.get(key).thenApply(versioned -> {
            if (versioned != null && Objects.equals(versioned.value(), value)) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.REMOVE_IF_VERSION_MATCH).withKey(key).withVersion(versioned.version()).build());
                return true;
            }
            return false;
        });
    }

    @Override
    public CompletableFuture<Boolean> replace(K key, V oldValue, V newValue) {
        return this.consistentMap.get(key).thenApply(versioned -> {
            if (versioned != null && Objects.equals(versioned.value(), oldValue)) {
                this.updates.put(key, MapUpdate.builder().withType(MapUpdate.Type.PUT_IF_VERSION_MATCH).withKey(key).withValue(newValue).withVersion(versioned.version()).build());
                return true;
            }
            return false;
        });
    }

    @Override
    public TransactionLog<MapUpdate<K, V>> log() {
        return new TransactionLog<MapUpdate<K, V>>(this.transactionId, 0L, Lists.newArrayList(this.updates.values()));
    }
}

