/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.tree;

import com.google.common.util.concurrent.MoreExecutors;
import io.atomix.core.tree.AtomicDocumentTree;
import io.atomix.core.tree.DocumentPath;
import io.atomix.core.tree.DocumentTreeEventListener;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.utils.time.Versioned;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public interface AsyncAtomicDocumentTree<V>
extends AsyncPrimitive {
    public DocumentPath root();

    default public CompletableFuture<Map<String, Versioned<V>>> getChildren(String path) {
        return this.getChildren(DocumentPath.from(path));
    }

    public CompletableFuture<Map<String, Versioned<V>>> getChildren(DocumentPath var1);

    default public CompletableFuture<Versioned<V>> get(String path) {
        return this.get(DocumentPath.from(path));
    }

    public CompletableFuture<Versioned<V>> get(DocumentPath var1);

    default public CompletableFuture<Versioned<V>> set(String path, V value) {
        return this.set(DocumentPath.from(path), value);
    }

    public CompletableFuture<Versioned<V>> set(DocumentPath var1, V var2);

    default public CompletableFuture<Boolean> create(String path, V value) {
        return this.create(DocumentPath.from(path), value);
    }

    public CompletableFuture<Boolean> create(DocumentPath var1, V var2);

    default public CompletableFuture<Boolean> createRecursive(String path, V value) {
        return this.createRecursive(DocumentPath.from(path), value);
    }

    public CompletableFuture<Boolean> createRecursive(DocumentPath var1, V var2);

    default public CompletableFuture<Boolean> replace(String path, V newValue, long version) {
        return this.replace(DocumentPath.from(path), newValue, (V)version);
    }

    public CompletableFuture<Boolean> replace(DocumentPath var1, V var2, long var3);

    default public CompletableFuture<Boolean> replace(String path, V newValue, V currentValue) {
        return this.replace(DocumentPath.from(path), newValue, currentValue);
    }

    public CompletableFuture<Boolean> replace(DocumentPath var1, V var2, V var3);

    default public CompletableFuture<Versioned<V>> remove(String path) {
        return this.remove(DocumentPath.from(path));
    }

    public CompletableFuture<Versioned<V>> remove(DocumentPath var1);

    default public CompletableFuture<Void> addListener(DocumentPath path, DocumentTreeEventListener<V> listener) {
        return this.addListener(path, listener, MoreExecutors.directExecutor());
    }

    public CompletableFuture<Void> addListener(DocumentPath var1, DocumentTreeEventListener<V> var2, Executor var3);

    public CompletableFuture<Void> removeListener(DocumentTreeEventListener<V> var1);

    default public CompletableFuture<Void> addListener(DocumentTreeEventListener<V> listener) {
        return this.addListener(this.root(), listener, MoreExecutors.directExecutor());
    }

    default public CompletableFuture<Void> addListener(DocumentTreeEventListener<V> listener, Executor executor) {
        return this.addListener(this.root(), listener, executor);
    }

    default public AtomicDocumentTree<V> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public AtomicDocumentTree<V> sync(Duration var1);
}

