/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.utils.config;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import io.atomix.core.AtomixRegistry;
import io.atomix.core.utils.config.PolymorphicTypeMapper;
import io.atomix.utils.config.ConfigMapper;
import io.atomix.utils.config.ConfigurationException;
import io.atomix.utils.config.TypedConfig;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;

public class PolymorphicConfigMapper
extends ConfigMapper {
    private final AtomixRegistry registry;
    private final Collection<PolymorphicTypeMapper> polymorphicTypes;

    public PolymorphicConfigMapper(ClassLoader classLoader, AtomixRegistry registry) {
        this(classLoader, registry, Collections.emptyList());
    }

    public PolymorphicConfigMapper(ClassLoader classLoader, AtomixRegistry registry, PolymorphicTypeMapper ... mappers) {
        this(classLoader, registry, Arrays.asList(mappers));
    }

    public PolymorphicConfigMapper(ClassLoader classLoader, AtomixRegistry registry, Collection<PolymorphicTypeMapper> mappers) {
        super(classLoader);
        this.registry = (AtomixRegistry)Preconditions.checkNotNull((Object)registry);
        this.polymorphicTypes = mappers;
    }

    protected <T> T newInstance(Config config, String key, Class<T> clazz) {
        Object instance;
        if (this.isPolymorphicType(clazz)) {
            PolymorphicTypeMapper typeMapper = this.polymorphicTypes.stream().filter(mapper -> mapper.getConfigClass().isAssignableFrom(clazz)).filter(mapper -> mapper.getTypePath() != null && config.hasPath(mapper.getTypePath()) || mapper.getTypePath() == null).findFirst().orElse(null);
            if (typeMapper == null) {
                throw new ConfigurationException("Cannot instantiate abstract type " + clazz.getName());
            }
            String typeName = typeMapper.getTypePath() != null ? config.getString(typeMapper.getTypePath()) : key;
            Class<TypedConfig<?>> concreteClass = typeMapper.getConcreteClass(this.registry, typeName);
            if (concreteClass == null) {
                throw new ConfigurationException("Unknown " + key + " type '" + typeName + "'");
            }
            try {
                instance = concreteClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ConfigurationException(concreteClass.getName() + " needs a public no-args constructor to be used as a bean", (Throwable)e);
            }
        }
        try {
            instance = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException(clazz.getName() + " needs a public no-args constructor to be used as a bean", (Throwable)e);
        }
        return instance;
    }

    protected void checkRemainingProperties(Set<String> missingProperties, List<String> availableProperties, String path, Class<?> clazz) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        List cleanNames = missingProperties.stream().filter(propertyName -> !this.isPolymorphicType(clazz) || !this.polymorphicTypes.stream().anyMatch(type -> Objects.equals(type.getTypePath(), propertyName))).map(propertyName -> this.toPath(path, (String)propertyName)).filter(propertyName -> !properties.containsKey(propertyName)).filter(propertyName -> properties.entrySet().stream().noneMatch(entry -> entry.getKey().toString().startsWith(propertyName + "."))).sorted().collect(Collectors.toList());
        if (!cleanNames.isEmpty()) {
            throw new ConfigurationException("Unknown properties present in configuration: " + Joiner.on((String)", ").join(cleanNames) + "\nAvailable properties:\n- " + Joiner.on((String)"\n- ").join(availableProperties));
        }
    }

    private boolean isPolymorphicType(Class<?> clazz) {
        return this.polymorphicTypes.stream().anyMatch(polymorphicType -> polymorphicType.getConfigClass() == clazz);
    }
}

