/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.value.impl;

import io.atomix.core.value.AsyncAtomicValue;
import io.atomix.core.value.AsyncDistributedValue;
import io.atomix.core.value.DistributedValue;
import io.atomix.core.value.DistributedValueBuilder;
import io.atomix.core.value.DistributedValueConfig;
import io.atomix.core.value.impl.AtomicValueProxy;
import io.atomix.core.value.impl.AtomicValueService;
import io.atomix.core.value.impl.DelegatingAsyncDistributedValue;
import io.atomix.core.value.impl.GossipDistributedValue;
import io.atomix.core.value.impl.TranscodingAsyncAtomicValue;
import io.atomix.primitive.PrimitiveManagementService;
import io.atomix.primitive.protocol.GossipProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.value.ValueProtocol;
import io.atomix.primitive.proxy.ProxyClient;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;

public class DefaultDistributedValueBuilder<V>
extends DistributedValueBuilder<V> {
    public DefaultDistributedValueBuilder(String name, DistributedValueConfig config, PrimitiveManagementService managementService) {
        super(name, config, managementService);
    }

    public CompletableFuture<DistributedValue<V>> buildAsync() {
        PrimitiveProtocol protocol = this.protocol();
        if (protocol instanceof GossipProtocol) {
            if (protocol instanceof ValueProtocol) {
                CompletableFuture future = this.managementService.getPrimitiveCache().getPrimitive(this.name, () -> CompletableFuture.completedFuture(((ValueProtocol)protocol).newValueDelegate(this.name, this.serializer(), this.managementService)).thenApply(map -> new GossipDistributedValue(this.name, protocol, map)));
                return future.thenApply(AsyncDistributedValue::sync);
            }
            return Futures.exceptionalFuture((Throwable)new UnsupportedOperationException("Values are not supported by the provided gossip protocol"));
        }
        return ((CompletableFuture)((CompletableFuture)this.newProxy(AtomicValueService.class, new ServiceConfig()).thenCompose(proxy -> new AtomicValueProxy((ProxyClient<AtomicValueService>)proxy, this.managementService.getPrimitiveRegistry()).connect())).thenApply(elector -> {
            Serializer serializer = this.serializer();
            return new TranscodingAsyncAtomicValue<Object, byte[]>((AsyncAtomicValue<byte[]>)elector, key -> serializer.encode(key), bytes -> serializer.decode(bytes));
        })).thenApply(value -> new DelegatingAsyncDistributedValue(value).sync());
    }
}

