/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.core.workqueue;

import com.google.common.collect.ImmutableList;
import io.atomix.core.workqueue.Task;
import io.atomix.core.workqueue.WorkQueue;
import io.atomix.core.workqueue.WorkQueueStats;
import io.atomix.primitive.AsyncPrimitive;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public interface AsyncWorkQueue<E>
extends AsyncPrimitive {
    public CompletableFuture<Void> addMultiple(Collection<E> var1);

    public CompletableFuture<Collection<Task<E>>> take(int var1);

    public CompletableFuture<Void> complete(Collection<String> var1);

    public CompletableFuture<Void> registerTaskProcessor(Consumer<E> var1, int var2, Executor var3);

    public CompletableFuture<Void> stopProcessing();

    public CompletableFuture<WorkQueueStats> stats();

    default public CompletableFuture<Void> complete(String ... taskIds) {
        return this.complete(Arrays.asList(taskIds));
    }

    default public CompletableFuture<Void> addOne(E item) {
        return this.addMultiple((Collection<E>)ImmutableList.of(item));
    }

    default public CompletableFuture<Task<E>> take() {
        return this.take(1).thenApply(tasks -> tasks.isEmpty() ? null : (Task)tasks.iterator().next());
    }

    default public WorkQueue<E> sync() {
        return this.sync(Duration.ofMillis(5000L));
    }

    public WorkQueue<E> sync(Duration var1);
}

