/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter;

import io.zeebe.exporter.ElasticsearchExporter;
import io.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.zeebe.exporter.ElasticsearchExporterException;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.ValueType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;

public class ElasticsearchClient {
    public static final String INDEX_TEMPLATE_FILENAME_PATTERN = "/zeebe-record-%s-template.json";
    public static final String INDEX_DELIMITER = "_";
    private final ElasticsearchExporterConfiguration configuration;
    private final Logger log;
    protected final RestHighLevelClient client;
    private BulkRequest bulkRequest;
    private final DateTimeFormatter formatter;

    public ElasticsearchClient(ElasticsearchExporterConfiguration configuration, Logger log) {
        this.configuration = configuration;
        this.log = log;
        this.client = this.createClient();
        this.bulkRequest = new BulkRequest();
        this.formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);
    }

    public void close() throws IOException {
        this.client.close();
    }

    public void index(Record<?> record) {
        IndexRequest request = new IndexRequest(this.indexFor(record), this.typeFor(record), this.idFor(record)).source(record.toJson(), XContentType.JSON);
        this.bulk(request);
    }

    public void bulk(IndexRequest indexRequest) {
        this.bulkRequest.add(indexRequest);
    }

    public boolean flush() {
        boolean success = true;
        if (this.bulkRequest.numberOfActions() > 0) {
            try {
                BulkResponse responses = this.client.bulk(this.bulkRequest, RequestOptions.DEFAULT);
                success = this.checkBulkResponses(responses);
            }
            catch (IOException e) {
                throw new ElasticsearchExporterException("Failed to flush bulk", e);
            }
            if (success) {
                this.bulkRequest = new BulkRequest();
            }
        }
        return success;
    }

    private boolean checkBulkResponses(BulkResponse responses) {
        for (BulkItemResponse response : responses) {
            if (!response.isFailed()) continue;
            this.log.warn("Failed to flush at least one bulk request {}", (Object)response.getFailureMessage());
            return false;
        }
        return true;
    }

    public boolean shouldFlush() {
        return this.bulkRequest.numberOfActions() >= this.configuration.bulk.size;
    }

    public boolean putIndexTemplate(ValueType valueType) {
        String templateName = this.indexPrefixForValueType(valueType);
        String filename = ElasticsearchClient.indexTemplateForValueType(valueType);
        return this.putIndexTemplate(templateName, filename, INDEX_DELIMITER);
    }

    public boolean putIndexTemplate(String templateName, String filename, String indexDelimiter) {
        Map template;
        block15: {
            try (InputStream inputStream = ElasticsearchExporter.class.getResourceAsStream(filename);){
                if (inputStream != null) {
                    template = XContentHelper.convertToMap((XContent)XContentType.JSON.xContent(), (InputStream)inputStream, (boolean)true);
                    break block15;
                }
                throw new ElasticsearchExporterException("Failed to find index template in classpath " + filename);
            }
            catch (IOException e) {
                throw new ElasticsearchExporterException("Failed to load index template from classpath " + filename, e);
            }
        }
        template.put("index_patterns", Collections.singletonList(templateName + indexDelimiter + "*"));
        template.put("aliases", Collections.singletonMap(templateName, Collections.EMPTY_MAP));
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(template);
        return this.putIndexTemplate(request);
    }

    private boolean putIndexTemplate(PutIndexTemplateRequest putIndexTemplateRequest) {
        try {
            return this.client.indices().putTemplate(putIndexTemplateRequest, RequestOptions.DEFAULT).isAcknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to put index template", e);
        }
    }

    private RestHighLevelClient createClient() {
        HttpHost httpHost = ElasticsearchClient.urlToHttpHost(this.configuration.url);
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost}).setHttpClientConfigCallback(this::setHttpClientConfigCallback);
        return new RestHighLevelClient(builder);
    }

    private HttpAsyncClientBuilder setHttpClientConfigCallback(HttpAsyncClientBuilder builder) {
        builder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
        if (this.configuration.authentication.isPresent()) {
            this.setupBasicAuthentication(builder);
        }
        return builder;
    }

    private void setupBasicAuthentication(HttpAsyncClientBuilder builder) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.configuration.authentication.username, this.configuration.authentication.password));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private static HttpHost urlToHttpHost(String url) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new ElasticsearchExporterException("Failed to parse url " + url, e);
        }
        return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
    }

    protected String indexFor(Record<?> record) {
        return this.indexPrefixForValueType(record.getMetadata().getValueType()) + INDEX_DELIMITER + this.formatter.format(record.getTimestamp());
    }

    protected String idFor(Record<?> record) {
        return record.getMetadata().getPartitionId() + "-" + record.getPosition();
    }

    protected String typeFor(Record<?> record) {
        return "_doc";
    }

    private String indexPrefixForValueType(ValueType valueType) {
        return this.configuration.index.prefix + "-" + ElasticsearchClient.valueTypeToString(valueType);
    }

    private static String valueTypeToString(ValueType valueType) {
        return valueType.name().toLowerCase().replaceAll(INDEX_DELIMITER, "-");
    }

    private static String indexTemplateForValueType(ValueType valueType) {
        return String.format(INDEX_TEMPLATE_FILENAME_PATTERN, ElasticsearchClient.valueTypeToString(valueType));
    }
}

