/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter;

import io.zeebe.exporter.ElasticsearchClient;
import io.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.exporter.api.context.Context;
import io.zeebe.exporter.api.context.Controller;
import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import java.time.Duration;
import org.slf4j.Logger;

public class ElasticsearchExporter
implements Exporter {
    public static final String ZEEBE_RECORD_TEMPLATE_JSON = "/zeebe-record-template.json";
    private Logger log;
    private Controller controller;
    private ElasticsearchExporterConfiguration configuration;
    private ElasticsearchClient client;
    private long lastPosition = -1L;
    private boolean indexTemplatesCreated;

    public void configure(Context context) {
        this.log = context.getLogger();
        this.configuration = (ElasticsearchExporterConfiguration)context.getConfiguration().instantiate(ElasticsearchExporterConfiguration.class);
        this.log.debug("Exporter configured with {}", (Object)this.configuration);
        context.setFilter((Context.RecordFilter)new ElasticsearchRecordFilter(this.configuration));
    }

    public void open(Controller controller) {
        this.controller = controller;
        this.client = this.createClient();
        this.scheduleDelayedFlush();
        this.log.info("Exporter opened");
    }

    protected ElasticsearchClient createClient() {
        return new ElasticsearchClient(this.configuration, this.log);
    }

    public void close() {
        this.flush();
        try {
            this.client.close();
        }
        catch (Exception e) {
            this.log.warn("Failed to close elasticsearch client", (Throwable)e);
        }
        this.log.info("Exporter closed");
    }

    public void export(Record record) {
        if (!this.indexTemplatesCreated) {
            this.createIndexTemplates();
        }
        this.client.index(record);
        this.lastPosition = record.getPosition();
        if (this.client.shouldFlush()) {
            this.flush();
        }
    }

    private void flushAndReschedule() {
        this.flush();
        this.scheduleDelayedFlush();
    }

    private void scheduleDelayedFlush() {
        this.controller.scheduleTask(Duration.ofSeconds(this.configuration.bulk.delay), this::flushAndReschedule);
    }

    private void flush() {
        if (this.client.flush()) {
            this.controller.updateLastExportedRecordPosition(this.lastPosition);
        } else {
            this.log.warn("Failed to flush bulk completely");
        }
    }

    private void createIndexTemplates() {
        ElasticsearchExporterConfiguration.IndexConfiguration index = this.configuration.index;
        if (index.createTemplate) {
            this.createRootIndexTemplate();
            if (index.deployment) {
                this.createValueIndexTemplate(ValueType.DEPLOYMENT);
            }
            if (index.incident) {
                this.createValueIndexTemplate(ValueType.INCIDENT);
            }
            if (index.job) {
                this.createValueIndexTemplate(ValueType.JOB);
            }
            if (index.jobBatch) {
                this.createValueIndexTemplate(ValueType.JOB_BATCH);
            }
            if (index.message) {
                this.createValueIndexTemplate(ValueType.MESSAGE);
            }
            if (index.messageSubscription) {
                this.createValueIndexTemplate(ValueType.MESSAGE_SUBSCRIPTION);
            }
            if (index.variable) {
                this.createValueIndexTemplate(ValueType.VARIABLE);
            }
            if (index.variableDocument) {
                this.createValueIndexTemplate(ValueType.VARIABLE_DOCUMENT);
            }
            if (index.workflowInstance) {
                this.createValueIndexTemplate(ValueType.WORKFLOW_INSTANCE);
            }
            if (index.workflowInstanceCreation) {
                this.createValueIndexTemplate(ValueType.WORKFLOW_INSTANCE_CREATION);
            }
            if (index.workflowInstanceSubscription) {
                this.createValueIndexTemplate(ValueType.WORKFLOW_INSTANCE_SUBSCRIPTION);
            }
        }
        this.indexTemplatesCreated = true;
    }

    private void createRootIndexTemplate() {
        String templateName = this.configuration.index.prefix;
        String filename = ZEEBE_RECORD_TEMPLATE_JSON;
        if (!this.client.putIndexTemplate(templateName, ZEEBE_RECORD_TEMPLATE_JSON, "-")) {
            this.log.warn("Put index template {} from file {} was not acknowledged", (Object)templateName, (Object)ZEEBE_RECORD_TEMPLATE_JSON);
        }
    }

    private void createValueIndexTemplate(ValueType valueType) {
        if (!this.client.putIndexTemplate(valueType)) {
            this.log.warn("Put index template for value type {} was not acknowledged", (Object)valueType);
        }
    }

    private class ElasticsearchRecordFilter
    implements Context.RecordFilter {
        private final ElasticsearchExporterConfiguration configuration;

        ElasticsearchRecordFilter(ElasticsearchExporterConfiguration configuration) {
            this.configuration = configuration;
        }

        public boolean acceptType(RecordType recordType) {
            return this.configuration.shouldIndexRecordType(recordType);
        }

        public boolean acceptValue(ValueType valueType) {
            return this.configuration.shouldIndexValueType(valueType);
        }
    }
}

