/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.exporter;

import io.zeebe.protocol.record.Record;
import io.zeebe.protocol.record.RecordMetadata;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;

public class ElasticsearchExporterConfiguration {
    public String url = "http://localhost:9200";
    public IndexConfiguration index = new IndexConfiguration();
    public BulkConfiguration bulk = new BulkConfiguration();
    public AuthenticationConfiguration authentication = new AuthenticationConfiguration();

    public String toString() {
        return "ElasticsearchExporterConfiguration{url='" + this.url + '\'' + ", index=" + this.index + ", bulk=" + this.bulk + ", authentication=" + this.authentication + '}';
    }

    public boolean shouldIndexRecord(Record<?> record) {
        RecordMetadata metadata = record.getMetadata();
        return this.shouldIndexRecordType(metadata.getRecordType()) && this.shouldIndexValueType(metadata.getValueType());
    }

    public boolean shouldIndexValueType(ValueType valueType) {
        switch (valueType) {
            case DEPLOYMENT: {
                return this.index.deployment;
            }
            case INCIDENT: {
                return this.index.incident;
            }
            case JOB: {
                return this.index.job;
            }
            case JOB_BATCH: {
                return this.index.jobBatch;
            }
            case MESSAGE: {
                return this.index.message;
            }
            case MESSAGE_SUBSCRIPTION: {
                return this.index.messageSubscription;
            }
            case VARIABLE: {
                return this.index.variable;
            }
            case VARIABLE_DOCUMENT: {
                return this.index.variableDocument;
            }
            case WORKFLOW_INSTANCE: {
                return this.index.workflowInstance;
            }
            case WORKFLOW_INSTANCE_CREATION: {
                return this.index.workflowInstanceCreation;
            }
            case WORKFLOW_INSTANCE_SUBSCRIPTION: {
                return this.index.workflowInstanceSubscription;
            }
        }
        return false;
    }

    public boolean shouldIndexRecordType(RecordType recordType) {
        switch (recordType) {
            case EVENT: {
                return this.index.event;
            }
            case COMMAND: {
                return this.index.command;
            }
            case COMMAND_REJECTION: {
                return this.index.rejection;
            }
        }
        return false;
    }

    public static class AuthenticationConfiguration {
        public String username;
        public String password;

        public boolean isPresent() {
            return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty();
        }

        public String toString() {
            return "AuthenticationConfiguration{username='" + this.username + '\'' + '}';
        }
    }

    public static class BulkConfiguration {
        public int delay = 5;
        public int size = 1000;

        public String toString() {
            return "BulkConfiguration{delay=" + this.delay + ", size=" + this.size + '}';
        }
    }

    public static class IndexConfiguration {
        public String prefix = "zeebe-record";
        public boolean createTemplate = true;
        public boolean command = false;
        public boolean event = true;
        public boolean rejection = false;
        public boolean deployment = true;
        public boolean incident = true;
        public boolean job = true;
        public boolean jobBatch = false;
        public boolean message = false;
        public boolean messageSubscription = false;
        public boolean raft = false;
        public boolean variable = true;
        public boolean variableDocument = false;
        public boolean workflowInstance = true;
        public boolean workflowInstanceCreation = false;
        public boolean workflowInstanceSubscription = false;

        public String toString() {
            return "IndexConfiguration{indexPrefix='" + this.prefix + '\'' + ", createTemplate=" + this.createTemplate + ", command=" + this.command + ", event=" + this.event + ", rejection=" + this.rejection + ", deployment=" + this.deployment + ", incident=" + this.incident + ", job=" + this.job + ", message=" + this.message + ", messageSubscription=" + this.messageSubscription + ", raft=" + this.raft + ", variable=" + this.variable + ", variableDocument=" + this.variableDocument + ", workflowInstance=" + this.workflowInstance + ", workflowInstanceCreation=" + this.workflowInstanceCreation + ", workflowInstanceSubscription=" + this.workflowInstanceSubscription + '}';
        }
    }
}

