/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.xml;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.xml.EncodedDataType;
import uk.co.real_logic.sbe.xml.Presence;
import uk.co.real_logic.sbe.xml.Type;
import uk.co.real_logic.sbe.xml.XmlSchemaParser;

public class EnumType
extends Type {
    public static final String ENUM_TYPE = "enum";
    private final PrimitiveType encodingType;
    private final PrimitiveValue nullValue;
    private final Map<PrimitiveValue, ValidValue> validValueByPrimitiveValueMap = new LinkedHashMap<PrimitiveValue, ValidValue>();
    private final Map<String, ValidValue> validValueByNameMap = new LinkedHashMap<String, ValidValue>();

    public EnumType(Node node) throws XPathExpressionException {
        this(node, null, null);
    }

    public EnumType(Node node, String givenName, String referencedName) throws XPathExpressionException {
        super(node, givenName, referencedName);
        EncodedDataType encodedDataType;
        String encodingTypeStr;
        XPath xPath = XPathFactory.newInstance().newXPath();
        switch (encodingTypeStr = XmlSchemaParser.getAttributeValue(node, "encodingType")) {
            case "char": 
            case "uint8": 
            case "int8": 
            case "int16": 
            case "uint16": 
            case "int32": {
                this.encodingType = PrimitiveType.get(encodingTypeStr);
                encodedDataType = null;
                break;
            }
            default: {
                Node encodingTypeNode = (Node)xPath.compile(String.format("%s[@name='%s']", "/*[local-name() = 'messageSchema']/types/type", encodingTypeStr)).evaluate(node.getOwnerDocument(), XPathConstants.NODE);
                if (null == encodingTypeNode) {
                    throw new IllegalArgumentException("illegal encodingType for enum " + encodingTypeStr);
                }
                encodedDataType = new EncodedDataType(encodingTypeNode);
                if (encodedDataType.length() != 1) {
                    throw new IllegalArgumentException("illegal encodingType for enum " + encodingTypeStr + " length not equal to 1");
                }
                this.encodingType = encodedDataType.primitiveType();
            }
        }
        String nullValueStr = XmlSchemaParser.getAttributeValueOrNull(node, "nullValue");
        if (null != nullValueStr) {
            if (this.presence() != Presence.OPTIONAL) {
                XmlSchemaParser.handleError(node, "nullValue set, but presence is not optional");
            }
            this.nullValue = PrimitiveValue.parse(nullValueStr, this.encodingType);
        } else if (this.presence() == Presence.OPTIONAL) {
            if (null != encodedDataType && null != encodedDataType.nullValue()) {
                this.nullValue = encodedDataType.nullValue();
            } else {
                XmlSchemaParser.handleError(node, "presence optional but no null value found");
                this.nullValue = null;
            }
        } else {
            this.nullValue = null;
        }
        NodeList list = (NodeList)xPath.compile("validValue").evaluate(node, XPathConstants.NODESET);
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            ValidValue v = new ValidValue(list.item(i), this.encodingType);
            if (this.validValueByPrimitiveValueMap.get(v.primitiveValue()) != null) {
                XmlSchemaParser.handleWarning(node, "validValue already exists for value: " + v.primitiveValue());
            }
            if (this.validValueByNameMap.get(v.name()) != null) {
                XmlSchemaParser.handleWarning(node, "validValue already exists for name: " + v.name());
            }
            if (PrimitiveType.CHAR != this.encodingType) {
                long nullLongValue;
                long value = v.primitiveValue().longValue();
                long minValue = null != encodedDataType && null != encodedDataType.minValue() ? encodedDataType.minValue().longValue() : this.encodingType.minValue().longValue();
                long maxValue = null != encodedDataType && null != encodedDataType.maxValue() ? encodedDataType.maxValue().longValue() : this.encodingType.maxValue().longValue();
                long l = nullLongValue = null != this.nullValue ? this.nullValue.longValue() : this.encodingType.nullValue().longValue();
                if (nullLongValue == value) {
                    XmlSchemaParser.handleError(node, "validValue " + v.name() + " uses nullValue: " + (null != this.nullValue ? this.nullValue : this.encodingType.nullValue()));
                } else if (value < minValue || value > maxValue) {
                    XmlSchemaParser.handleError(node, "validValue " + v.name() + " outside of range " + minValue + " - " + maxValue + ": " + value);
                }
            }
            this.validValueByPrimitiveValueMap.put(v.primitiveValue(), v);
            this.validValueByNameMap.put(v.name(), v);
        }
    }

    public PrimitiveType encodingType() {
        return this.encodingType;
    }

    @Override
    public int encodedLength() {
        if (this.presence() == Presence.CONSTANT) {
            return 0;
        }
        return this.encodingType.size();
    }

    public ValidValue getValidValue(PrimitiveValue value) {
        return this.validValueByPrimitiveValueMap.get(value);
    }

    public ValidValue getValidValue(String name) {
        return this.validValueByNameMap.get(name);
    }

    public PrimitiveValue nullValue() {
        return this.nullValue;
    }

    public Collection<ValidValue> validValues() {
        return this.validValueByNameMap.values();
    }

    @Override
    public boolean isVariableLength() {
        return false;
    }

    public String toString() {
        return "EnumType{encodingType=" + (Object)((Object)this.encodingType) + ", nullValue=" + this.nullValue + ", validValueByPrimitiveValueMap=" + this.validValueByPrimitiveValueMap + ", validValueByNameMap=" + this.validValueByNameMap + '}';
    }

    public static class ValidValue {
        private final String name;
        private final String description;
        private final PrimitiveValue value;
        private final int sinceVersion;
        private final int deprecated;

        public ValidValue(Node node, PrimitiveType encodingType) {
            this.name = XmlSchemaParser.getAttributeValue(node, "name");
            this.description = XmlSchemaParser.getAttributeValueOrNull(node, "description");
            this.value = PrimitiveValue.parse(node.getFirstChild().getNodeValue(), encodingType);
            this.sinceVersion = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "sinceVersion", "0"));
            this.deprecated = Integer.parseInt(XmlSchemaParser.getAttributeValue(node, "deprecated", "0"));
            XmlSchemaParser.checkForValidName(node, this.name);
        }

        public PrimitiveValue primitiveValue() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public int sinceVersion() {
            return this.sinceVersion;
        }

        public int deprecated() {
            return this.deprecated;
        }

        public String toString() {
            return "ValidValue{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", value=" + this.value + ", sinceVersion=" + this.sinceVersion + ", deprecated=" + this.deprecated + '}';
        }
    }
}

