/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker;

import io.atomix.cluster.MemberId;
import io.atomix.cluster.messaging.ManagedMessagingService;
import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.cluster.messaging.MessagingService;
import io.atomix.cluster.messaging.impl.NettyMessagingService;
import io.atomix.core.Atomix;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.atomix.utils.net.Address;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.PartitionListener;
import io.zeebe.broker.SpringBrokerBridge;
import io.zeebe.broker.bootstrap.CloseProcess;
import io.zeebe.broker.bootstrap.StartProcess;
import io.zeebe.broker.clustering.atomix.AtomixFactory;
import io.zeebe.broker.clustering.topology.TopologyManagerImpl;
import io.zeebe.broker.clustering.topology.TopologyPartitionListenerImpl;
import io.zeebe.broker.engine.impl.DeploymentDistributorImpl;
import io.zeebe.broker.engine.impl.LongPollingJobNotification;
import io.zeebe.broker.engine.impl.PartitionCommandSenderImpl;
import io.zeebe.broker.engine.impl.SubscriptionApiCommandMessageHandlerService;
import io.zeebe.broker.exporter.jar.ExporterJarLoadException;
import io.zeebe.broker.exporter.repo.ExporterLoadException;
import io.zeebe.broker.exporter.repo.ExporterRepository;
import io.zeebe.broker.system.EmbeddedGatewayService;
import io.zeebe.broker.system.SystemContext;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.broker.system.configuration.ClusterCfg;
import io.zeebe.broker.system.configuration.DataCfg;
import io.zeebe.broker.system.configuration.ExporterCfg;
import io.zeebe.broker.system.configuration.NetworkCfg;
import io.zeebe.broker.system.configuration.SocketBindingCfg;
import io.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import io.zeebe.broker.system.management.BrokerAdminService;
import io.zeebe.broker.system.management.BrokerAdminServiceImpl;
import io.zeebe.broker.system.management.LeaderManagementRequestHandler;
import io.zeebe.broker.system.management.deployment.PushDeploymentRequestHandler;
import io.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionHealthBroadcaster;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.broker.system.partitions.TypedRecordProcessorsFactory;
import io.zeebe.broker.system.partitions.ZeebePartition;
import io.zeebe.broker.system.partitions.impl.AtomixPartitionMessagingService;
import io.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import io.zeebe.broker.system.partitions.impl.PartitionTransitionImpl;
import io.zeebe.broker.system.partitions.impl.steps.AtomixLogStoragePartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.ExporterDirectorPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.FollowerPostStoragePartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.LeaderPostStoragePartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.LogDeletionPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.LogStreamPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.RaftLogReaderPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.RocksDbMetricExporterPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.SnapshotDirectorPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.SnapshotReplicationPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.StateControllerPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.StreamProcessorPartitionStep;
import io.zeebe.broker.system.partitions.impl.steps.ZeebeDbPartitionStep;
import io.zeebe.broker.transport.backpressure.PartitionAwareRequestLimiter;
import io.zeebe.broker.transport.commandapi.CommandApiService;
import io.zeebe.engine.processing.EngineProcessors;
import io.zeebe.engine.processing.deployment.DeploymentResponder;
import io.zeebe.engine.processing.deployment.distribute.DeploymentDistributor;
import io.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.zeebe.engine.processing.streamprocessor.ProcessingContext;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.protocol.impl.encoding.BrokerInfo;
import io.zeebe.snapshots.broker.SnapshotStoreSupplier;
import io.zeebe.snapshots.broker.impl.FileBasedSnapshotStoreFactory;
import io.zeebe.snapshots.raft.ReceivableSnapshotStoreFactory;
import io.zeebe.transport.ServerTransport;
import io.zeebe.transport.TransportFactory;
import io.zeebe.util.LogUtil;
import io.zeebe.util.SocketUtil;
import io.zeebe.util.VersionUtil;
import io.zeebe.util.exception.UncheckedExecutionException;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.clock.ActorClock;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class Broker
implements AutoCloseable {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final List<PartitionStep> LEADER_STEPS = List.of(new AtomixLogStoragePartitionStep(), new LogStreamPartitionStep(), new RaftLogReaderPartitionStep(), new SnapshotReplicationPartitionStep(), new StateControllerPartitionStep(), new LogDeletionPartitionStep(), new LeaderPostStoragePartitionStep(), new ZeebeDbPartitionStep(), new StreamProcessorPartitionStep(), new SnapshotDirectorPartitionStep(), new RocksDbMetricExporterPartitionStep(), new ExporterDirectorPartitionStep());
    private static final List<PartitionStep> FOLLOWER_STEPS = List.of(new RaftLogReaderPartitionStep(), new SnapshotReplicationPartitionStep(), new StateControllerPartitionStep(), new LogDeletionPartitionStep(), new FollowerPostStoragePartitionStep());
    private final SystemContext brokerContext;
    private final List<PartitionListener> partitionListeners;
    private boolean isClosed = false;
    private Atomix atomix;
    private CompletableFuture<Broker> startFuture;
    private TopologyManagerImpl topologyManager;
    private LeaderManagementRequestHandler managementRequestHandler;
    private CommandApiService commandHandler;
    private ActorScheduler scheduler;
    private CloseProcess closeProcess;
    private EmbeddedGatewayService embeddedGatewayService;
    private ServerTransport serverTransport;
    private BrokerHealthCheckService healthCheckService;
    private final List<DiskSpaceUsageListener> diskSpaceUsageListeners = new ArrayList<DiskSpaceUsageListener>();
    private final SpringBrokerBridge springBrokerBridge;
    private DiskSpaceUsageMonitor diskSpaceUsageMonitor;
    private SnapshotStoreSupplier snapshotStoreSupplier;
    private final List<ZeebePartition> partitions = new ArrayList<ZeebePartition>();
    private BrokerAdminService brokerAdminService;

    public Broker(SystemContext systemContext, SpringBrokerBridge springBrokerBridge) {
        this.brokerContext = systemContext;
        this.partitionListeners = new ArrayList<PartitionListener>();
        this.springBrokerBridge = springBrokerBridge;
    }

    public Broker(BrokerCfg cfg, String basePath, ActorClock clock, SpringBrokerBridge springBrokerBridge) {
        this(new SystemContext(cfg, basePath, clock), springBrokerBridge);
    }

    public void addPartitionListener(PartitionListener listener) {
        this.partitionListeners.add(listener);
    }

    public synchronized CompletableFuture<Broker> start() {
        if (this.startFuture == null) {
            this.logBrokerStart();
            this.startFuture = new CompletableFuture();
            LogUtil.doWithMDC(this.brokerContext.getDiagnosticContext(), this::internalStart);
        }
        return this.startFuture;
    }

    private void logBrokerStart() {
        if (LOG.isInfoEnabled()) {
            BrokerCfg brokerCfg = this.getConfig();
            LOG.info("Version: {}", (Object)VersionUtil.getVersion());
            LOG.info("Starting broker {} with configuration {}", (Object)brokerCfg.getCluster().getNodeId(), (Object)brokerCfg.toJson());
        }
    }

    private void internalStart() {
        StartProcess startProcess = this.initStart();
        try {
            this.closeProcess = startProcess.start();
            this.startFuture.complete(this);
        }
        catch (Exception bootStrapException) {
            BrokerCfg brokerCfg = this.getConfig();
            LOG.error("Failed to start broker {}!", (Object)brokerCfg.getCluster().getNodeId(), (Object)bootStrapException);
            UncheckedExecutionException exception = new UncheckedExecutionException("Failed to start broker", (Throwable)bootStrapException);
            this.startFuture.completeExceptionally((Throwable)exception);
            throw exception;
        }
    }

    private StartProcess initStart() {
        BrokerCfg brokerCfg = this.getConfig();
        NetworkCfg networkCfg = brokerCfg.getNetwork();
        ClusterCfg clusterCfg = brokerCfg.getCluster();
        BrokerInfo localBroker = new BrokerInfo(clusterCfg.getNodeId(), SocketUtil.toHostAndPortString((InetSocketAddress)networkCfg.getCommandApi().getAdvertisedAddress()));
        StartProcess startContext = new StartProcess("Broker-" + localBroker.getNodeId());
        startContext.addStep("actor scheduler", this::actorSchedulerStep);
        startContext.addStep("membership and replication protocol", () -> this.atomixCreateStep(brokerCfg, localBroker));
        startContext.addStep("command api transport", () -> this.commandApiTransportStep(clusterCfg, brokerCfg.getNetwork().getCommandApi(), localBroker));
        startContext.addStep("command api handler", () -> this.commandApiHandlerStep(brokerCfg, localBroker));
        startContext.addStep("subscription api", () -> this.subscriptionAPIStep(localBroker));
        startContext.addStep("cluster services", () -> this.atomix.start().join());
        startContext.addStep("topology manager", () -> this.topologyManagerStep(clusterCfg, localBroker));
        if (brokerCfg.getGateway().isEnable()) {
            startContext.addStep("embedded gateway", () -> {
                this.embeddedGatewayService = new EmbeddedGatewayService(brokerCfg, this.scheduler, this.atomix);
                return this.embeddedGatewayService;
            });
        }
        startContext.addStep("monitoring services", () -> this.monitoringServerStep(localBroker));
        startContext.addStep("disk space monitor", () -> this.diskSpaceMonitorStep(brokerCfg.getData()));
        startContext.addStep("leader management request handler", () -> this.managementRequestStep(localBroker));
        startContext.addStep("zeebe partitions", () -> this.partitionsStep(brokerCfg, clusterCfg, localBroker));
        startContext.addStep("register diskspace usage listeners", this::addDiskSpaceUsageListeners);
        startContext.addStep("upgrade manager", this::addBrokerAdminService);
        return startContext;
    }

    private AutoCloseable addBrokerAdminService() {
        BrokerAdminServiceImpl adminService = new BrokerAdminServiceImpl(this.partitions);
        this.scheduleActor(adminService);
        this.brokerAdminService = adminService;
        this.springBrokerBridge.registerBrokerAdminServiceSupplier(() -> this.brokerAdminService);
        return adminService;
    }

    private AutoCloseable actorSchedulerStep() {
        this.scheduler = this.brokerContext.getScheduler();
        this.scheduler.start();
        return () -> this.scheduler.stop().get(this.brokerContext.getStepTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    private AutoCloseable atomixCreateStep(BrokerCfg brokerCfg, BrokerInfo localBroker) {
        FileBasedSnapshotStoreFactory snapshotStoreFactory = new FileBasedSnapshotStoreFactory(this.scheduler, localBroker.getNodeId());
        this.snapshotStoreSupplier = snapshotStoreFactory;
        this.atomix = AtomixFactory.fromConfiguration(brokerCfg, (ReceivableSnapshotStoreFactory)snapshotStoreFactory);
        return () -> this.atomix.stop().get(this.brokerContext.getStepTimeout().toMillis(), TimeUnit.MILLISECONDS);
    }

    private AutoCloseable commandApiTransportStep(ClusterCfg clusterCfg, SocketBindingCfg commpandApiConfig, BrokerInfo localBroker) {
        ManagedMessagingService messagingService = this.createMessagingService(clusterCfg, commpandApiConfig);
        messagingService.start().join();
        LOG.debug("Bound command API to {}, using advertised address {} ", (Object)messagingService.bindingAddresses(), (Object)messagingService.address());
        TransportFactory transportFactory = new TransportFactory(this.scheduler);
        this.serverTransport = transportFactory.createServerTransport(localBroker.getNodeId(), (MessagingService)messagingService);
        return () -> {
            this.serverTransport.close();
            messagingService.stop().join();
        };
    }

    private ManagedMessagingService createMessagingService(ClusterCfg clusterCfg, SocketBindingCfg socketCfg) {
        MessagingConfig messagingConfig = new MessagingConfig();
        messagingConfig.setInterfaces(List.of(socketCfg.getHost()));
        messagingConfig.setPort(Integer.valueOf(socketCfg.getPort()));
        return new NettyMessagingService(clusterCfg.getClusterName(), Address.from((String)socketCfg.getAdvertisedHost(), (int)socketCfg.getAdvertisedPort()), messagingConfig);
    }

    private AutoCloseable commandApiHandlerStep(BrokerCfg brokerCfg, BrokerInfo localBroker) {
        BackpressureCfg backpressureCfg = brokerCfg.getBackpressure();
        PartitionAwareRequestLimiter limiter = PartitionAwareRequestLimiter.newNoopLimiter();
        if (backpressureCfg.isEnabled()) {
            limiter = PartitionAwareRequestLimiter.newLimiter(backpressureCfg);
        }
        this.commandHandler = new CommandApiService(this.serverTransport, localBroker, limiter);
        this.partitionListeners.add(this.commandHandler);
        this.scheduleActor(this.commandHandler);
        this.diskSpaceUsageListeners.add(this.commandHandler);
        return this.commandHandler;
    }

    private AutoCloseable subscriptionAPIStep(BrokerInfo localBroker) {
        SubscriptionApiCommandMessageHandlerService messageHandlerService = new SubscriptionApiCommandMessageHandlerService(localBroker, this.atomix);
        this.partitionListeners.add(messageHandlerService);
        this.scheduleActor(messageHandlerService);
        this.diskSpaceUsageListeners.add(messageHandlerService);
        return messageHandlerService;
    }

    private void addDiskSpaceUsageListeners() {
        this.diskSpaceUsageListeners.forEach(this.diskSpaceUsageMonitor::addDiskUsageListener);
    }

    private void scheduleActor(Actor actor) {
        this.brokerContext.getScheduler().submitActor(actor).join(this.brokerContext.getStepTimeout().toSeconds(), TimeUnit.SECONDS);
    }

    private AutoCloseable topologyManagerStep(ClusterCfg clusterCfg, BrokerInfo localBroker) {
        this.topologyManager = new TopologyManagerImpl(this.atomix, localBroker, clusterCfg);
        this.partitionListeners.add(this.topologyManager);
        this.scheduleActor(this.topologyManager);
        return this.topologyManager;
    }

    private AutoCloseable monitoringServerStep(BrokerInfo localBroker) {
        this.healthCheckService = new BrokerHealthCheckService(localBroker, this.atomix);
        this.springBrokerBridge.registerBrokerHealthCheckServiceSupplier(() -> this.healthCheckService);
        this.partitionListeners.add(this.healthCheckService);
        this.scheduleActor(this.healthCheckService);
        return () -> this.healthCheckService.close();
    }

    private AutoCloseable diskSpaceMonitorStep(DataCfg data) {
        this.diskSpaceUsageMonitor = new DiskSpaceUsageMonitor(data);
        if (data.isDiskUsageMonitoringEnabled()) {
            this.scheduleActor(this.diskSpaceUsageMonitor);
            this.diskSpaceUsageListeners.forEach(l -> this.diskSpaceUsageMonitor.addDiskUsageListener((DiskSpaceUsageListener)l));
            return () -> this.diskSpaceUsageMonitor.close();
        }
        LOG.info("Skipping start of disk space usage monitor, as it is disabled by configuration");
        return () -> {};
    }

    private AutoCloseable managementRequestStep(BrokerInfo localBroker) {
        this.managementRequestHandler = new LeaderManagementRequestHandler(localBroker, this.atomix);
        this.scheduleActor(this.managementRequestHandler);
        this.partitionListeners.add(this.managementRequestHandler);
        this.diskSpaceUsageListeners.add(this.managementRequestHandler);
        return this.managementRequestHandler;
    }

    private AutoCloseable partitionsStep(BrokerCfg brokerCfg, ClusterCfg clusterCfg, BrokerInfo localBroker) throws Exception {
        RaftPartitionGroup partitionGroup = (RaftPartitionGroup)this.atomix.getPartitionService().getPartitionGroup("raft-partition");
        MemberId nodeId = this.atomix.getMembershipService().getLocalMember().id();
        List owningPartitions = partitionGroup.getPartitions().stream().filter(partition -> partition.members().contains(nodeId)).map(RaftPartition.class::cast).collect(Collectors.toList());
        StartProcess partitionStartProcess = new StartProcess("Broker-" + nodeId + " partitions");
        for (RaftPartition owningPartition : owningPartitions) {
            Integer partitionId = (Integer)owningPartition.id().id();
            partitionStartProcess.addStep("partition " + partitionId, () -> {
                AtomixPartitionMessagingService messagingService = new AtomixPartitionMessagingService(this.atomix.getCommunicationService(), this.atomix.getMembershipService(), owningPartition.members());
                PartitionContext context = new PartitionContext(localBroker.getNodeId(), owningPartition, this.partitionListeners, messagingService, this.scheduler, brokerCfg, this.commandHandler, this.snapshotStoreSupplier, this.createFactory(this.topologyManager, clusterCfg, this.atomix, this.managementRequestHandler), this.buildExporterRepository(brokerCfg), new PartitionProcessingState(owningPartition));
                PartitionTransitionImpl transitionBehavior = new PartitionTransitionImpl(context, LEADER_STEPS, FOLLOWER_STEPS);
                ZeebePartition zeebePartition = new ZeebePartition(context, transitionBehavior);
                this.scheduleActor(zeebePartition);
                zeebePartition.addFailureListener(new PartitionHealthBroadcaster(partitionId, this.topologyManager::onHealthChanged));
                this.healthCheckService.registerMonitoredPartition((Integer)owningPartition.id().id(), zeebePartition);
                this.diskSpaceUsageListeners.add(zeebePartition);
                this.partitions.add(zeebePartition);
                return zeebePartition;
            });
        }
        return partitionStartProcess.start();
    }

    private ExporterRepository buildExporterRepository(BrokerCfg cfg) {
        ExporterRepository exporterRepository = new ExporterRepository();
        Set<Map.Entry<String, ExporterCfg>> exporterEntries = cfg.getExporters().entrySet();
        for (Map.Entry<String, ExporterCfg> exporterEntry : exporterEntries) {
            String id = exporterEntry.getKey();
            ExporterCfg exporterCfg = exporterEntry.getValue();
            try {
                exporterRepository.load(id, exporterCfg);
            }
            catch (ExporterJarLoadException | ExporterLoadException e) {
                throw new IllegalStateException("Failed to load exporter with configuration: " + exporterCfg, e);
            }
        }
        return exporterRepository;
    }

    private TypedRecordProcessorsFactory createFactory(TopologyManagerImpl topologyManager, ClusterCfg clusterCfg, Atomix atomix, LeaderManagementRequestHandler requestHandler) {
        return (actor, zeebeState, processingContext) -> {
            LogStream stream = processingContext.getLogStream();
            TopologyPartitionListenerImpl partitionListener = new TopologyPartitionListenerImpl(actor);
            topologyManager.addTopologyPartitionListener(partitionListener);
            DeploymentDistributorImpl deploymentDistributor = new DeploymentDistributorImpl(atomix, partitionListener, zeebeState.getDeploymentState(), actor);
            PartitionCommandSenderImpl partitionCommandSender = new PartitionCommandSenderImpl(atomix, topologyManager, actor);
            SubscriptionCommandSender subscriptionCommandSender = new SubscriptionCommandSender(stream.getPartitionId(), (PartitionCommandSender)partitionCommandSender);
            PushDeploymentRequestHandler deploymentRequestHandler = requestHandler.getPushDeploymentRequestHandler();
            LongPollingJobNotification jobsAvailableNotification = new LongPollingJobNotification(atomix.getEventService());
            return EngineProcessors.createEngineProcessors((ProcessingContext)processingContext, (int)clusterCfg.getPartitionsCount(), (SubscriptionCommandSender)subscriptionCommandSender, (DeploymentDistributor)deploymentDistributor, (DeploymentResponder)deploymentRequestHandler, jobsAvailableNotification::onJobsAvailable);
        };
    }

    public BrokerCfg getConfig() {
        return this.brokerContext.getBrokerConfiguration();
    }

    @Override
    public void close() {
        LogUtil.doWithMDC(this.brokerContext.getDiagnosticContext(), () -> {
            if (!this.isClosed && this.startFuture != null) {
                ((CompletableFuture)this.startFuture.thenAccept(b -> {
                    this.closeProcess.closeReverse();
                    this.isClosed = true;
                    LOG.info("Broker shut down.");
                })).join();
            }
        });
    }

    public EmbeddedGatewayService getEmbeddedGatewayService() {
        return this.embeddedGatewayService;
    }

    public Atomix getAtomix() {
        return this.atomix;
    }

    public DiskSpaceUsageMonitor getDiskSpaceUsageMonitor() {
        return this.diskSpaceUsageMonitor;
    }

    public BrokerAdminService getBrokerAdminService() {
        return this.brokerAdminService;
    }

    public SystemContext getBrokerContext() {
        return this.brokerContext;
    }
}

