/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.bootstrap;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.bootstrap.StartProcess;
import io.zeebe.broker.system.monitoring.BrokerStepMetrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public final class CloseProcess
implements AutoCloseable {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final List<CloseStep> closeableSteps;
    private final String name;
    private final BrokerStepMetrics brokerStepMetrics;

    CloseProcess(String name, BrokerStepMetrics brokerStepMetrics) {
        this.name = name;
        this.brokerStepMetrics = brokerStepMetrics;
        this.closeableSteps = new ArrayList<CloseStep>();
    }

    void addCloser(String name, AutoCloseable closingFunction) {
        this.closeableSteps.add(new CloseStep(name, closingFunction));
    }

    public void closeReverse() {
        Collections.reverse(this.closeableSteps);
        try {
            long durationTime = StartProcess.takeDuration(this::closingStepByStep);
            LOG.info("Closing {} succeeded. Closed {} steps in {} ms.", new Object[]{this.name, this.closeableSteps.size(), durationTime});
        }
        catch (Exception willNeverHappen) {
            LOG.error("Unexpected exception occured on closing {}", (Object)this.name, (Object)willNeverHappen);
        }
    }

    private void closingStepByStep() {
        int index = 1;
        for (CloseStep closeableStep : this.closeableSteps) {
            try {
                LOG.info("Closing {} [{}/{}]: {}", new Object[]{this.name, index, this.closeableSteps.size(), closeableStep.getName()});
                long durationStepStarting = StartProcess.takeDuration(() -> closeableStep.getClosingFunction().close());
                this.brokerStepMetrics.observeDurationForCloseStep(closeableStep.getName(), durationStepStarting);
                LOG.debug("Closing {} [{}/{}]: {} closed in {} ms", new Object[]{this.name, index, this.closeableSteps.size(), closeableStep.getName(), durationStepStarting});
            }
            catch (Exception exceptionOnClose) {
                LOG.error("Closing {} [{}/{}]: {} failed to close.", new Object[]{this.name, index, this.closeableSteps.size(), closeableStep.getName(), exceptionOnClose});
            }
            ++index;
        }
    }

    @Override
    public void close() {
        this.closeReverse();
    }

    private static class CloseStep {
        private final String name;
        private final AutoCloseable closingFunction;

        CloseStep(String name, AutoCloseable closingFunction) {
            this.name = name;
            this.closingFunction = closingFunction;
        }

        String getName() {
            return this.name;
        }

        AutoCloseable getClosingFunction() {
            return this.closingFunction;
        }
    }
}

