/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.bootstrap;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.bootstrap.CheckedRunnable;
import io.zeebe.broker.bootstrap.CloseProcess;
import io.zeebe.broker.bootstrap.StartFunction;
import io.zeebe.broker.system.monitoring.BrokerStepMetrics;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class StartProcess {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final List<StartStep> startSteps;
    private final CloseProcess closeProcess;
    private final String name;
    private final BrokerStepMetrics brokerStepMetrics;

    public StartProcess(String name) {
        this.name = name;
        this.startSteps = new ArrayList<StartStep>();
        this.brokerStepMetrics = new BrokerStepMetrics();
        this.closeProcess = new CloseProcess(name, this.brokerStepMetrics);
    }

    public void addStep(String name, CheckedRunnable runnable) {
        this.startSteps.add(new StartStep(name, () -> {
            runnable.run();
            return () -> {};
        }));
    }

    public void addStep(String name, StartFunction startFunction) {
        this.startSteps.add(new StartStep(name, startFunction));
    }

    public CloseProcess start() throws Exception {
        long durationTime = StartProcess.takeDuration(this::startStepByStep);
        LOG.info("Bootstrap {} succeeded. Started {} steps in {} ms.", new Object[]{this.name, this.startSteps.size(), durationTime});
        return this.closeProcess;
    }

    private void startStepByStep() throws Exception {
        int index = 1;
        for (StartStep step : this.startSteps) {
            LOG.info("Bootstrap {} [{}/{}]: {}", new Object[]{this.name, index, this.startSteps.size(), step.getName()});
            try {
                long durationStepStarting = StartProcess.takeDuration(() -> {
                    AutoCloseable closer = step.getStartFunction().start();
                    this.closeProcess.addCloser(step.getName(), closer);
                });
                this.brokerStepMetrics.observeDurationForStarStep(step.getName(), durationStepStarting);
                LOG.debug("Bootstrap {} [{}/{}]: {} started in {} ms", new Object[]{this.name, index, this.startSteps.size(), step.getName(), durationStepStarting});
            }
            catch (Exception startException) {
                LOG.error("Bootstrap {} [{}/{}]: {} failed with unexpected exception.", new Object[]{this.name, index, this.startSteps.size(), step.getName(), startException});
                this.closeProcess.closeReverse();
                throw startException;
            }
            ++index;
        }
    }

    static long takeDuration(CheckedRunnable runner) throws Exception {
        long startTime = System.currentTimeMillis();
        runner.run();
        long endTime = System.currentTimeMillis();
        return endTime - startTime;
    }

    private static class StartStep {
        private final String name;
        private final StartFunction startFunction;

        StartStep(String name, StartFunction startFunction) {
            this.name = name;
            this.startFunction = startFunction;
        }

        String getName() {
            return this.name;
        }

        StartFunction getStartFunction() {
            return this.startFunction;
        }
    }
}

