/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.clustering.topology;

import io.zeebe.broker.clustering.topology.TopologyPartitionListener;
import io.zeebe.protocol.impl.encoding.BrokerInfo;
import io.zeebe.protocol.record.PartitionRole;
import io.zeebe.util.sched.ActorControl;
import org.agrona.collections.Int2IntHashMap;

public final class TopologyPartitionListenerImpl
implements TopologyPartitionListener {
    private final Int2IntHashMap partitionLeaders = new Int2IntHashMap(-1);
    private final ActorControl actor;

    public TopologyPartitionListenerImpl(ActorControl actor) {
        this.actor = actor;
    }

    @Override
    public void onPartitionLeaderUpdated(int partitionId, BrokerInfo member) {
        if (member.getPartitionRoles().get(partitionId) == PartitionRole.LEADER) {
            this.actor.submit(() -> this.updatePartitionLeader(partitionId, member));
        }
    }

    private void updatePartitionLeader(int partitionId, BrokerInfo member) {
        int currentLeader = this.partitionLeaders.get(partitionId);
        if (currentLeader != member.getNodeId()) {
            this.partitionLeaders.put(partitionId, member.getNodeId());
        }
    }

    public Int2IntHashMap getPartitionLeaders() {
        return this.partitionLeaders;
    }
}

