/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.engine.impl;

import io.atomix.cluster.MemberId;
import io.atomix.core.Atomix;
import io.zeebe.broker.clustering.topology.TopologyManager;
import io.zeebe.broker.clustering.topology.TopologyPartitionListenerImpl;
import io.zeebe.engine.processing.message.command.PartitionCommandSender;
import io.zeebe.util.buffer.BufferWriter;
import io.zeebe.util.sched.ActorControl;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.concurrent.UnsafeBuffer;

public final class PartitionCommandSenderImpl
implements PartitionCommandSender {
    private final Atomix atomix;
    private final TopologyPartitionListenerImpl partitionListener;

    public PartitionCommandSenderImpl(Atomix atomix, TopologyManager topologyManager, ActorControl actor) {
        this.atomix = atomix;
        this.partitionListener = new TopologyPartitionListenerImpl(actor);
        topologyManager.addTopologyPartitionListener(this.partitionListener);
    }

    public boolean sendCommand(int receiverPartitionId, BufferWriter command) {
        Int2IntHashMap partitionLeaders = this.partitionListener.getPartitionLeaders();
        if (!partitionLeaders.containsKey(receiverPartitionId)) {
            return true;
        }
        int partitionLeader = partitionLeaders.get(receiverPartitionId);
        byte[] bytes = new byte[command.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        command.write((MutableDirectBuffer)buffer, 0);
        this.atomix.getCommunicationService().send("subscription", (Object)bytes, MemberId.from((String)("" + partitionLeader)));
        return true;
    }
}

