/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

public final class ExporterObjectMapper {
    private final ObjectMapper jsonObjectMapper;

    public ExporterObjectMapper() {
        InjectableValues.Std injectableValues = new InjectableValues.Std();
        injectableValues.addValue(ExporterObjectMapper.class, (Object)this);
        this.jsonObjectMapper = this.createDefaultObjectMapper((InjectableValues)injectableValues);
    }

    private ObjectMapper createDefaultObjectMapper(InjectableValues injectableValues) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setInjectableValues(injectableValues);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.enable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS);
        objectMapper.disable(SerializationFeature.WRITE_DATE_TIMESTAMPS_AS_NANOSECONDS);
        return objectMapper;
    }

    public String toJson(Object value) {
        try {
            return this.jsonObjectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Failed to serialize object '%s' to JSON", value), e);
        }
    }
}

