/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.context;

import io.zeebe.exporter.api.context.Configuration;
import io.zeebe.exporter.api.context.Context;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.util.EnsureUtil;
import org.slf4j.Logger;

public final class ExporterContext
implements Context {
    private static final Context.RecordFilter DEFAULT_FILTER = new AcceptAllRecordsFilter();
    private final Logger logger;
    private final Configuration configuration;
    private Context.RecordFilter filter = DEFAULT_FILTER;

    public ExporterContext(Logger logger, Configuration configuration) {
        this.logger = logger;
        this.configuration = configuration;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Context.RecordFilter getFilter() {
        return this.filter;
    }

    public void setFilter(Context.RecordFilter filter) {
        EnsureUtil.ensureNotNull((String)"filter", (Object)filter);
        this.filter = filter;
    }

    private static class AcceptAllRecordsFilter
    implements Context.RecordFilter {
        private AcceptAllRecordsFilter() {
        }

        public boolean acceptType(RecordType recordType) {
            return true;
        }

        public boolean acceptValue(ValueType valueType) {
            return true;
        }
    }
}

