/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.jar;

import io.zeebe.broker.exporter.jar.ExporterJarClassLoader;
import io.zeebe.broker.exporter.jar.ExporterJarLoadException;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ExporterJarRepository {
    public static final String JAR_EXTENSION = ".jar";
    private final Map<Path, ExporterJarClassLoader> loadedJars;

    public ExporterJarRepository() {
        this(new HashMap<Path, ExporterJarClassLoader>());
    }

    public ExporterJarRepository(Map<Path, ExporterJarClassLoader> loadedJars) {
        this.loadedJars = loadedJars;
    }

    public Map<Path, ExporterJarClassLoader> getJars() {
        return Collections.unmodifiableMap(this.loadedJars);
    }

    public ExporterJarClassLoader remove(String jarPath) {
        return this.remove(Paths.get(jarPath, new String[0]));
    }

    public ExporterJarClassLoader remove(Path jarPath) {
        return this.loadedJars.remove(jarPath);
    }

    public ExporterJarClassLoader load(String jarPath) throws ExporterJarLoadException {
        return this.load(Paths.get(jarPath, new String[0]));
    }

    public ExporterJarClassLoader load(Path jarPath) throws ExporterJarLoadException {
        ExporterJarClassLoader classLoader = this.loadedJars.get(jarPath);
        if (classLoader == null) {
            this.verifyJarPath(jarPath);
            classLoader = ExporterJarClassLoader.ofPath(jarPath);
            this.loadedJars.put(jarPath, classLoader);
        }
        return classLoader;
    }

    private void verifyJarPath(Path path) throws ExporterJarLoadException {
        File jarFile = path.toFile();
        if (!jarFile.getName().endsWith(JAR_EXTENSION)) {
            throw new ExporterJarLoadException(path, "is not a JAR");
        }
        if (!jarFile.canRead()) {
            throw new ExporterJarLoadException(path, "is not readable");
        }
    }
}

