/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.stream;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.exporter.context.ExporterContext;
import io.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.zeebe.broker.exporter.stream.ExporterMetrics;
import io.zeebe.broker.exporter.stream.ExportersState;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.exporter.api.Exporter;
import io.zeebe.exporter.api.context.Context;
import io.zeebe.exporter.api.context.Controller;
import io.zeebe.exporter.api.context.ScheduledTask;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.record.Record;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.ScheduledTimer;
import java.time.Duration;
import org.slf4j.Logger;

final class ExporterContainer
implements Controller {
    private static final Logger LOG = Loggers.EXPORTER_LOGGER;
    private static final String SKIP_POSITION_UPDATE_ERROR_MESSAGE = "Failed to update exporter position when skipping filtered record, can be skipped, but may indicate an issue if it occurs often";
    private final ExporterContext context;
    private final Exporter exporter;
    private long position;
    private long lastUnacknowledgedPosition;
    private ExportersState exportersState;
    private ExporterMetrics metrics;
    private ActorControl actor;

    ExporterContainer(ExporterDescriptor descriptor) {
        this.context = new ExporterContext(Loggers.getExporterLogger(descriptor.getId()), descriptor.getConfiguration());
        this.exporter = descriptor.newInstance();
    }

    void initContainer(ActorControl actor, ExporterMetrics metrics, ExportersState state) {
        this.actor = actor;
        this.metrics = metrics;
        this.exportersState = state;
    }

    void initPosition() {
        this.lastUnacknowledgedPosition = this.position = this.exportersState.getPosition(this.getId());
        if (this.position == -1L) {
            this.exportersState.setPosition(this.getId(), -1L);
        }
    }

    void openExporter() {
        LOG.debug("Open exporter with id '{}'", (Object)this.getId());
        this.exporter.open((Controller)this);
    }

    public ExporterContext getContext() {
        return this.context;
    }

    public Exporter getExporter() {
        return this.exporter;
    }

    public long getPosition() {
        return this.position;
    }

    long getLastUnacknowledgedPosition() {
        return this.lastUnacknowledgedPosition;
    }

    void updatePositionOnSkipIfUpToDate(long eventPosition) {
        if (this.position >= this.lastUnacknowledgedPosition && this.position < eventPosition) {
            try {
                this.updateExporterLastExportedRecordPosition(eventPosition);
            }
            catch (Exception e) {
                LOG.warn(SKIP_POSITION_UPDATE_ERROR_MESSAGE, (Throwable)e);
            }
        }
    }

    private void updateExporterLastExportedRecordPosition(long eventPosition) {
        if (this.position < eventPosition) {
            this.exportersState.setPosition(this.getId(), eventPosition);
            this.metrics.setLastUpdatedExportedPosition(this.getId(), eventPosition);
            this.position = eventPosition;
        }
    }

    public void updateLastExportedRecordPosition(long position) {
        this.actor.run(() -> this.updateExporterLastExportedRecordPosition(position));
    }

    public void scheduleTask(Duration delay, Runnable task) {
        this.actor.runDelayed(delay, task);
    }

    public ScheduledTask scheduleCancellableTask(Duration delay, Runnable task) {
        ScheduledTimer scheduledTimer = this.actor.runDelayed(delay, task);
        return () -> ((ScheduledTimer)scheduledTimer).cancel();
    }

    public String getId() {
        return this.context.getConfiguration().getId();
    }

    private boolean acceptRecord(RecordMetadata metadata) {
        Context.RecordFilter filter = this.context.getFilter();
        return filter.acceptType(metadata.getRecordType()) && filter.acceptValue(metadata.getValueType());
    }

    void configureExporter() throws Exception {
        LOG.debug("Configure exporter with id '{}'", (Object)this.getId());
        this.exporter.configure((Context)this.context);
    }

    boolean exportRecord(RecordMetadata rawMetadata, TypedRecord typedEvent) {
        try {
            if (this.position < typedEvent.getPosition()) {
                if (this.acceptRecord(rawMetadata)) {
                    this.export((Record<?>)typedEvent);
                } else {
                    this.updatePositionOnSkipIfUpToDate(typedEvent.getPosition());
                }
            }
            return true;
        }
        catch (Exception ex) {
            this.context.getLogger().warn("Error on exporting record with key {}", (Object)typedEvent.getKey(), (Object)ex);
            return false;
        }
    }

    private void export(Record<?> record) {
        this.exporter.export(record);
        this.lastUnacknowledgedPosition = record.getPosition();
    }

    public void close() {
        try {
            this.exporter.close();
        }
        catch (Exception e) {
            this.context.getLogger().error("Error on close", (Throwable)e);
        }
    }
}

