/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.exporter.stream;

import io.zeebe.broker.exporter.stream.ExporterPosition;
import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.TransactionContext;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import java.util.function.BiConsumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.LongArrayList;

public final class ExportersState {
    public static final long VALUE_NOT_FOUND = -1L;
    private final DbString exporterId;
    private final ExporterPosition position = new ExporterPosition();
    private final ColumnFamily<DbString, ExporterPosition> exporterPositionColumnFamily;

    public ExportersState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.exporterId = new DbString();
        this.exporterPositionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EXPORTER, transactionContext, (DbKey)this.exporterId, (DbValue)this.position);
    }

    public void setPosition(String exporterId, long position) {
        this.exporterId.wrapString(exporterId);
        this.setPosition(position);
    }

    public long getPosition(String exporterId) {
        this.exporterId.wrapString(exporterId);
        return this.getPosition();
    }

    public long getPosition(DirectBuffer exporterId) {
        this.exporterId.wrapBuffer(exporterId);
        return this.getPosition();
    }

    private long getPosition() {
        ExporterPosition pos = (ExporterPosition)this.exporterPositionColumnFamily.get((DbKey)this.exporterId);
        return pos == null ? -1L : pos.get();
    }

    private void setPosition(long position) {
        this.position.set(position);
        this.exporterPositionColumnFamily.put((DbKey)this.exporterId, (DbValue)this.position);
    }

    public void visitPositions(BiConsumer<String, Long> consumer) {
        this.exporterPositionColumnFamily.forEach((exporterId, position) -> consumer.accept(exporterId.toString(), position.get()));
    }

    public long getLowestPosition() {
        LongArrayList positions = new LongArrayList();
        this.visitPositions((id, pos) -> positions.addLong(pos.longValue()));
        return positions.longStream().min().orElse(-1L);
    }

    public void removePosition(String exporter) {
        this.exporterId.wrapString(exporter);
        this.exporterPositionColumnFamily.delete((DbKey)this.exporterId);
    }

    public boolean hasExporters() {
        return !this.exporterPositionColumnFamily.isEmpty();
    }
}

