/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system;

import io.atomix.cluster.AtomixCluster;
import io.atomix.core.Atomix;
import io.zeebe.broker.system.configuration.BrokerCfg;
import io.zeebe.gateway.Gateway;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.util.sched.ActorScheduler;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Function;

public final class EmbeddedGatewayService
implements AutoCloseable {
    private final Gateway gateway;

    public EmbeddedGatewayService(BrokerCfg configuration, ActorScheduler actorScheduler, Atomix atomix) {
        Function<GatewayCfg, BrokerClient> brokerClientFactory = cfg -> new BrokerClientImpl(cfg, (AtomixCluster)atomix, actorScheduler, false);
        this.gateway = new Gateway((GatewayCfg)configuration.getGateway(), brokerClientFactory, actorScheduler);
        this.startGateway();
    }

    @Override
    public void close() {
        if (this.gateway != null) {
            this.gateway.stop();
        }
    }

    public Gateway get() {
        return this.gateway;
    }

    private void startGateway() {
        try {
            this.gateway.start();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Gateway was not able to start", e);
        }
    }
}

