/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.management;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.exporter.stream.ExporterDirector;
import io.zeebe.broker.exporter.stream.ExporterPhase;
import io.zeebe.broker.system.management.BrokerAdminService;
import io.zeebe.broker.system.management.PartitionStatus;
import io.zeebe.broker.system.partitions.ZeebePartition;
import io.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.zeebe.snapshots.broker.impl.FileBasedSnapshotMetadata;
import io.zeebe.snapshots.raft.PersistedSnapshot;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class BrokerAdminServiceImpl
extends Actor
implements BrokerAdminService {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final List<ZeebePartition> partitions;

    public BrokerAdminServiceImpl(List<ZeebePartition> partitions) {
        this.partitions = partitions;
    }

    @Override
    public void pauseStreamProcessing() {
        this.actor.call(this::pauseStreamProcessingOnAllPartitions);
    }

    @Override
    public void resumeStreamProcessing() {
        this.actor.call(this::resumeStreamProcessingOnAllPartitions);
    }

    @Override
    public void pauseExporting() {
        this.actor.call(this::pauseExportingOnAllPartitions);
    }

    @Override
    public void resumeExporting() {
        this.actor.call(this::resumeExportingOnAllPartitions);
    }

    @Override
    public void takeSnapshot() {
        this.actor.call(() -> this.takeSnapshotOnAllPartitions(this.partitions));
    }

    @Override
    public void prepareForUpgrade() {
        this.actor.call(this::prepareAllPartitionsForSafeUpgrade);
    }

    @Override
    public Map<Integer, PartitionStatus> getPartitionStatus() {
        CompletableFuture future = new CompletableFuture();
        ConcurrentHashMap partitionStatuses = new ConcurrentHashMap();
        this.actor.call(() -> {
            List statusFutures = this.partitions.stream().map(partition -> this.getPartitionStatus((ZeebePartition)partition).whenComplete((ps, error) -> {
                if (error == null) {
                    partitionStatuses.put(partition.getPartitionId(), ps);
                }
            })).collect(Collectors.toList());
            CompletableFuture.allOf((CompletableFuture[])statusFutures.toArray(CompletableFuture[]::new)).thenAccept(r -> future.complete(partitionStatuses));
        });
        return (Map)future.join();
    }

    private CompletableFuture<PartitionStatus> getPartitionStatus(ZeebePartition partition) {
        CompletableFuture<PartitionStatus> partitionStatus = new CompletableFuture<PartitionStatus>();
        ActorFuture<Optional<StreamProcessor>> streamProcessorFuture = partition.getStreamProcessor();
        ActorFuture<Optional<ExporterDirector>> exporterDirectorFuture = partition.getExporterDirector();
        this.actor.runOnCompletion(List.of(streamProcessorFuture, exporterDirectorFuture), error -> {
            if (error != null) {
                partitionStatus.completeExceptionally((Throwable)error);
                return;
            }
            Optional streamProcessor = (Optional)streamProcessorFuture.join();
            Optional exporterDirector = (Optional)exporterDirectorFuture.join();
            if (streamProcessor.isPresent() && exporterDirector.isPresent()) {
                this.getLeaderPartitionStatus(partition, (StreamProcessor)streamProcessor.get(), (ExporterDirector)((Object)((Object)exporterDirector.get())), partitionStatus);
            } else {
                this.getFollowerPartitionStatus(partition, partitionStatus);
            }
        });
        return partitionStatus;
    }

    private void getFollowerPartitionStatus(ZeebePartition partition, CompletableFuture<PartitionStatus> partitionStatus) {
        Optional<String> snapshotId = this.getSnapshotId(partition);
        PartitionStatus status = PartitionStatus.ofFollower(snapshotId.orElse(null));
        partitionStatus.complete(status);
    }

    private void getLeaderPartitionStatus(ZeebePartition partition, StreamProcessor streamProcessor, ExporterDirector exporterDirector, CompletableFuture<PartitionStatus> partitionStatus) {
        ActorFuture positionFuture = streamProcessor.getLastProcessedPositionAsync();
        ActorFuture currentPhaseFuture = streamProcessor.getCurrentPhase();
        ActorFuture<ExporterPhase> exporterPhaseFuture = exporterDirector.getPhase();
        long exporterPosition = exporterDirector.getState().getLowestPosition();
        Optional<String> snapshotId = this.getSnapshotId(partition);
        Long processedPositionInSnapshot = snapshotId.flatMap(FileBasedSnapshotMetadata::ofFileName).map(FileBasedSnapshotMetadata::getProcessedPosition).orElse(null);
        this.actor.runOnCompletion(List.of(positionFuture, currentPhaseFuture, exporterPhaseFuture), error -> {
            if (error != null) {
                partitionStatus.completeExceptionally((Throwable)error);
                return;
            }
            Long processedPosition = (Long)positionFuture.join();
            StreamProcessor.Phase processorPhase = (StreamProcessor.Phase)currentPhaseFuture.join();
            ExporterPhase exporterPhase = (ExporterPhase)((Object)((Object)exporterPhaseFuture.join()));
            PartitionStatus status = PartitionStatus.ofLeader(processedPosition, snapshotId.orElse(null), processedPositionInSnapshot, processorPhase, exporterPhase, exporterPosition);
            partitionStatus.complete(status);
        });
    }

    private Optional<String> getSnapshotId(ZeebePartition partition) {
        return partition.getSnapshotStore().getLatestSnapshot().map(PersistedSnapshot::getId);
    }

    private void prepareAllPartitionsForSafeUpgrade() {
        LOG.info("Preparing for safe upgrade.");
        List<ActorFuture<Void>> pauseProcessingCompleted = this.pauseStreamProcessingOnAllPartitions();
        List<ActorFuture<Void>> pauseExportingCompleted = this.pauseExportingOnAllPartitions();
        List pauseAll = Stream.of(pauseProcessingCompleted, pauseExportingCompleted).flatMap(Collection::stream).collect(Collectors.toList());
        this.actor.runOnCompletion(pauseAll, t -> this.takeSnapshotOnAllPartitions(this.partitions));
    }

    private List<ActorFuture<Void>> pauseStreamProcessingOnAllPartitions() {
        LOG.info("Pausing StreamProcessor on all partitions.");
        return this.partitions.stream().map(ZeebePartition::pauseProcessing).collect(Collectors.toList());
    }

    private void resumeStreamProcessingOnAllPartitions() {
        LOG.info("Resuming paused StreamProcessor on all partitions.");
        this.partitions.forEach(ZeebePartition::resumeProcessing);
    }

    private void takeSnapshotOnAllPartitions(List<ZeebePartition> partitions) {
        LOG.info("Triggering Snapshots on all partitions.");
        partitions.forEach(ZeebePartition::triggerSnapshot);
    }

    private List<ActorFuture<Void>> pauseExportingOnAllPartitions() {
        LOG.info("Pausing exporting on all partitions.");
        return this.partitions.stream().map(ZeebePartition::pauseExporting).collect(Collectors.toList());
    }

    private void resumeExportingOnAllPartitions() {
        LOG.info("Resuming exporting on all partitions.");
        this.partitions.forEach(ZeebePartition::resumeExporting);
    }
}

