/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.monitoring;

import io.atomix.cluster.MemberId;
import io.atomix.core.Atomix;
import io.atomix.raft.partition.RaftPartitionGroup;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.PartitionListener;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.protocol.impl.encoding.BrokerInfo;
import io.zeebe.util.health.CriticalComponentsHealthMonitor;
import io.zeebe.util.health.HealthMonitor;
import io.zeebe.util.health.HealthMonitorable;
import io.zeebe.util.health.HealthStatus;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class BrokerHealthCheckService
extends Actor
implements PartitionListener {
    private static final String PARTITION_COMPONENT_NAME_FORMAT = "Partition-%d";
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final Atomix atomix;
    private final String actorName;
    private Map<Integer, Boolean> partitionInstallStatus;
    private volatile boolean brokerStarted = false;
    private final HealthMonitor healthMonitor;

    public BrokerHealthCheckService(BrokerInfo localBroker, Atomix atomix) {
        this.atomix = atomix;
        this.actorName = BrokerHealthCheckService.buildActorName((int)localBroker.getNodeId(), (String)"HealthCheckService");
        this.healthMonitor = new CriticalComponentsHealthMonitor(this.actor, LOG);
        this.initializePartitionInstallStatus();
        this.initializePartitionHealthStatus();
    }

    private void initializePartitionHealthStatus() {
        RaftPartitionGroup partitionGroup = (RaftPartitionGroup)this.atomix.getPartitionService().getPartitionGroup("raft-partition");
        MemberId nodeId = this.atomix.getMembershipService().getLocalMember().id();
        partitionGroup.getPartitions().stream().filter(partition -> partition.members().contains(nodeId)).map(partition -> (Integer)partition.id().id()).forEach(partitionId -> this.healthMonitor.monitorComponent(String.format(PARTITION_COMPONENT_NAME_FORMAT, partitionId)));
    }

    boolean isBrokerReady() {
        return this.brokerStarted;
    }

    @Override
    public ActorFuture<Void> onBecomingFollower(int partitionId, long term) {
        return this.updateBrokerReadyStatus(partitionId);
    }

    @Override
    public ActorFuture<Void> onBecomingLeader(int partitionId, long term, LogStream logStream) {
        return this.updateBrokerReadyStatus(partitionId);
    }

    @Override
    public ActorFuture<Void> onBecomingInactive(int partitionId, long term) {
        return CompletableActorFuture.completed(null);
    }

    private ActorFuture<Void> updateBrokerReadyStatus(int partitionId) {
        return this.actor.call(() -> {
            if (!this.brokerStarted) {
                this.partitionInstallStatus.put(partitionId, true);
                boolean bl = this.brokerStarted = !this.partitionInstallStatus.containsValue(false);
                if (this.brokerStarted) {
                    LOG.debug("All partitions are installed. Broker is ready!");
                }
            }
        });
    }

    private void initializePartitionInstallStatus() {
        RaftPartitionGroup partitionGroup = (RaftPartitionGroup)this.atomix.getPartitionService().getPartitionGroup("raft-partition");
        MemberId nodeId = this.atomix.getMembershipService().getLocalMember().id();
        this.partitionInstallStatus = partitionGroup.getPartitions().stream().filter(partition -> partition.members().contains(nodeId)).map(partition -> (Integer)partition.id().id()).collect(Collectors.toMap(Function.identity(), p -> false));
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarted() {
        this.healthMonitor.startMonitoring();
    }

    private void registerComponent(String componentName, HealthMonitorable component) {
        this.actor.run(() -> this.healthMonitor.registerComponent(componentName, component));
    }

    public void registerMonitoredPartition(int partitionId, HealthMonitorable partition) {
        String componentName = String.format(PARTITION_COMPONENT_NAME_FORMAT, partitionId);
        this.registerComponent(componentName, partition);
    }

    public boolean isBrokerHealthy() {
        return !this.actor.isClosed() && this.getBrokerHealth() == HealthStatus.HEALTHY;
    }

    private HealthStatus getBrokerHealth() {
        if (!this.isBrokerReady()) {
            return HealthStatus.UNHEALTHY;
        }
        return this.healthMonitor.getHealthStatus();
    }
}

