/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.monitoring;

import io.zeebe.broker.Broker;
import io.zeebe.broker.system.configuration.DataCfg;
import io.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.zeebe.util.sched.Actor;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;

public class DiskSpaceUsageMonitor
extends Actor {
    private final List<DiskSpaceUsageListener> diskSpaceUsageListeners = new ArrayList<DiskSpaceUsageListener>();
    private boolean currentDiskAvailableStatus = true;
    private LongSupplier freeDiskSpaceSupplier;
    private final Duration monitoringDelay;
    private final long minFreeDiskSpaceRequired;

    public DiskSpaceUsageMonitor(DataCfg dataCfg) {
        this.monitoringDelay = dataCfg.getDiskUsageMonitoringInterval();
        this.minFreeDiskSpaceRequired = dataCfg.getFreeDiskSpaceCommandWatermark();
        File directory = new File(dataCfg.getDirectory());
        this.freeDiskSpaceSupplier = directory::getUsableSpace;
    }

    protected void onActorStarted() {
        this.checkDiskUsageAndNotifyListeners();
        this.actor.runAtFixedRate(this.monitoringDelay, this::checkDiskUsageAndNotifyListeners);
    }

    private void checkDiskUsageAndNotifyListeners() {
        long freeDiskSpaceAvailable = this.freeDiskSpaceSupplier.getAsLong();
        boolean previousStatus = this.currentDiskAvailableStatus;
        boolean bl = this.currentDiskAvailableStatus = freeDiskSpaceAvailable >= this.minFreeDiskSpaceRequired;
        if (this.currentDiskAvailableStatus != previousStatus) {
            if (!this.currentDiskAvailableStatus) {
                Broker.LOG.warn("Out of disk space. Current available {} bytes. Minimum needed {} bytes.", (Object)freeDiskSpaceAvailable, (Object)this.minFreeDiskSpaceRequired);
                this.diskSpaceUsageListeners.forEach(DiskSpaceUsageListener::onDiskSpaceNotAvailable);
            } else {
                Broker.LOG.info("Disk space available again. Current available {} bytes", (Object)freeDiskSpaceAvailable);
                this.diskSpaceUsageListeners.forEach(DiskSpaceUsageListener::onDiskSpaceAvailable);
            }
        }
    }

    public void addDiskUsageListener(DiskSpaceUsageListener listener) {
        this.actor.call(() -> {
            this.diskSpaceUsageListeners.add(listener);
            if (!this.currentDiskAvailableStatus) {
                listener.onDiskSpaceNotAvailable();
            }
        });
    }

    public void removeDiskUsageListener(DiskSpaceUsageListener listener) {
        this.actor.call(() -> this.diskSpaceUsageListeners.remove(listener));
    }

    public void setFreeDiskSpaceSupplier(LongSupplier freeDiskSpaceSupplier) {
        this.freeDiskSpaceSupplier = freeDiskSpaceSupplier;
    }
}

