/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.monitoring;

import io.zeebe.broker.SpringBrokerBridge;
import io.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class MonitoringRestController {
    private static final String BROKER_READY_STATUS_URI = "/ready";
    private static final String METRICS_URI = "/metrics";
    private static final String BROKER_HEALTH_STATUS_URI = "/health";
    @Autowired
    private SpringBrokerBridge springBrokerBridge;

    @GetMapping(value={"/metrics"})
    public ModelAndView metrics() {
        return new ModelAndView("forward:/actuator/prometheus");
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<String> health() {
        boolean brokerHealthy = this.springBrokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerHealthy).orElse(false);
        HttpStatus status = brokerHealthy ? HttpStatus.NO_CONTENT : HttpStatus.SERVICE_UNAVAILABLE;
        return new ResponseEntity(status);
    }

    @GetMapping(value={"/ready"})
    public ResponseEntity<String> ready() {
        boolean brokerReady = this.springBrokerBridge.getBrokerHealthCheckService().map(BrokerHealthCheckService::isBrokerReady).orElse(false);
        HttpStatus status = brokerReady ? HttpStatus.NO_CONTENT : HttpStatus.SERVICE_UNAVAILABLE;
        return new ResponseEntity(status);
    }
}

