/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions;

import io.zeebe.util.health.FailureListener;
import io.zeebe.util.health.HealthStatus;

public final class PartitionHealthBroadcaster
implements FailureListener {
    private final Integer partitionId;
    private final PartitionHealthListener delegate;

    public PartitionHealthBroadcaster(Integer partitionId, PartitionHealthListener delegate) {
        this.partitionId = partitionId;
        this.delegate = delegate;
    }

    public void onFailure() {
        this.delegate.onHealthChanged(this.partitionId, HealthStatus.UNHEALTHY);
    }

    public void onRecovered() {
        this.delegate.onHealthChanged(this.partitionId, HealthStatus.HEALTHY);
    }

    @FunctionalInterface
    public static interface PartitionHealthListener {
        public void onHealthChanged(int var1, HealthStatus var2);
    }
}

