/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions;

import io.atomix.raft.RaftFailureListener;
import io.atomix.raft.partition.RaftPartition;
import io.zeebe.util.health.FailureListener;
import io.zeebe.util.health.HealthMonitorable;
import io.zeebe.util.health.HealthStatus;
import io.zeebe.util.sched.ActorControl;
import java.util.concurrent.CompletableFuture;

public class RaftPartitionHealth
implements HealthMonitorable,
RaftFailureListener {
    private final RaftPartition atomixRaftPartition;
    private FailureListener healthMonitor;
    private final ActorControl actor;
    private final RaftFailureListener raftFailureListener;
    private final String name;

    RaftPartitionHealth(RaftPartition atomixRaftPartition, ActorControl actor, RaftFailureListener listener) {
        this.atomixRaftPartition = atomixRaftPartition;
        this.actor = actor;
        this.raftFailureListener = listener;
        this.atomixRaftPartition.addFailureListener((RaftFailureListener)this);
        this.name = "Raft-" + atomixRaftPartition.id().id();
    }

    public HealthStatus getHealthStatus() {
        boolean isHealthy = this.atomixRaftPartition.getServer().isRunning();
        return isHealthy ? HealthStatus.HEALTHY : HealthStatus.UNHEALTHY;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> {
            this.healthMonitor = failureListener;
        });
    }

    public CompletableFuture<Void> onRaftFailed() {
        if (this.healthMonitor != null) {
            this.healthMonitor.onFailure();
        }
        return this.raftFailureListener.onRaftFailed();
    }

    public void close() {
        this.atomixRaftPartition.removeFailureListener((RaftFailureListener)this);
    }

    public String getName() {
        return this.name;
    }
}

