/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions;

import io.zeebe.util.health.FailureListener;
import io.zeebe.util.health.HealthMonitorable;
import io.zeebe.util.health.HealthStatus;

class ZeebePartitionHealth
implements HealthMonitorable {
    private HealthStatus healthStatus = HealthStatus.UNHEALTHY;
    private final String name;
    private FailureListener failureListener;
    private boolean servicesInstalled;
    private boolean diskSpaceAvailable = true;

    public ZeebePartitionHealth(int partitionId) {
        this.name = "ZeebePartition-" + partitionId;
    }

    public HealthStatus getHealthStatus() {
        return this.healthStatus;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.failureListener = failureListener;
    }

    private void updateHealthStatus() {
        boolean healthy = this.diskSpaceAvailable && this.servicesInstalled;
        HealthStatus previousStatus = this.healthStatus;
        this.healthStatus = healthy ? HealthStatus.HEALTHY : HealthStatus.UNHEALTHY;
        if (previousStatus != this.healthStatus && this.failureListener != null) {
            switch (this.healthStatus) {
                case HEALTHY: {
                    this.failureListener.onRecovered();
                    break;
                }
                case UNHEALTHY: {
                    this.failureListener.onFailure();
                    break;
                }
            }
        }
    }

    void setServicesInstalled(boolean servicesInstalled) {
        this.servicesInstalled = servicesInstalled;
        this.updateHealthStatus();
    }

    void setDiskSpaceAvailable(boolean diskSpaceAvailable) {
        this.diskSpaceAvailable = diskSpaceAvailable;
        this.updateHealthStatus();
    }

    public String getName() {
        return this.name;
    }
}

