/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl;

import io.zeebe.broker.system.partitions.StateController;
import io.zeebe.broker.system.partitions.impl.RandomDuration;
import io.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.snapshots.raft.TransientSnapshot;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.SchedulingHints;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;

public final class AsyncSnapshotDirector
extends Actor {
    public static final Duration MINIMUM_SNAPSHOT_PERIOD = Duration.ofMinutes(1L);
    private static final Logger LOG = Loggers.SNAPSHOT_LOGGER;
    private static final String LOG_MSG_WAIT_UNTIL_COMMITTED = "Finished taking snapshot, need to wait until last written event position {} is committed, current commit position is {}. After that snapshot can be marked as valid.";
    private static final String ERROR_MSG_ON_RESOLVE_PROCESSED_POS = "Unexpected error in resolving last processed position.";
    private static final String ERROR_MSG_ON_RESOLVE_WRITTEN_POS = "Unexpected error in resolving last written position.";
    private static final String ERROR_MSG_MOVE_SNAPSHOT = "Unexpected exception occurred on moving valid snapshot.";
    private final StateController stateController;
    private final LogStream logStream;
    private final Duration snapshotRate;
    private final String processorName;
    private final StreamProcessor streamProcessor;
    private final String actorName;
    private ActorCondition commitCondition;
    private Long lastWrittenEventPosition;
    private TransientSnapshot pendingSnapshot;
    private long lowerBoundSnapshotPosition;
    private boolean takingSnapshot;
    private boolean persistingSnapshot;

    public AsyncSnapshotDirector(int nodeId, StreamProcessor streamProcessor, StateController stateController, LogStream logStream, Duration snapshotRate) {
        this.streamProcessor = streamProcessor;
        this.stateController = stateController;
        this.logStream = logStream;
        this.processorName = streamProcessor.getName();
        this.snapshotRate = snapshotRate;
        this.actorName = AsyncSnapshotDirector.buildActorName((int)nodeId, (String)"SnapshotDirector", (int)logStream.getPartitionId());
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorStarting() {
        this.actor.setSchedulingHints(SchedulingHints.ioBound());
        Duration firstSnapshotTime = RandomDuration.getRandomDurationMinuteBased(MINIMUM_SNAPSHOT_PERIOD, this.snapshotRate);
        this.actor.runDelayed(firstSnapshotTime, this::scheduleSnapshotOnRate);
        this.lastWrittenEventPosition = null;
        this.commitCondition = this.actor.onCondition(this.getConditionNameForPosition(), this::persistSnapshotIfLastWrittenPositionCommitted);
        this.logStream.registerOnCommitPositionUpdatedCondition(this.commitCondition);
    }

    protected void onActorCloseRequested() {
        this.logStream.removeOnCommitPositionUpdatedCondition(this.commitCondition);
    }

    public ActorFuture<Void> closeAsync() {
        if (this.actor.isClosed()) {
            return CompletableActorFuture.completed(null);
        }
        return super.closeAsync();
    }

    private void scheduleSnapshotOnRate() {
        this.actor.runAtFixedRate(this.snapshotRate, this::prepareTakingSnapshot);
        this.prepareTakingSnapshot();
    }

    private String getConditionNameForPosition() {
        return this.getName() + "-wait-for-endPosition-committed";
    }

    public void forceSnapshot() {
        this.actor.call(this::prepareTakingSnapshot);
    }

    private void prepareTakingSnapshot() {
        if (this.takingSnapshot) {
            return;
        }
        this.takingSnapshot = true;
        ActorFuture futureLastProcessedPosition = this.streamProcessor.getLastProcessedPositionAsync();
        this.actor.runOnCompletion(futureLastProcessedPosition, (lastProcessedPosition, error) -> {
            if (error == null) {
                if (lastProcessedPosition == -1L) {
                    LOG.debug("We will skip taking this snapshot, because we haven't processed something yet.");
                    this.takingSnapshot = false;
                    return;
                }
                this.lowerBoundSnapshotPosition = lastProcessedPosition;
                this.logStream.getCommitPositionAsync().onComplete((commitPosition, errorOnRetrievingCommitPosition) -> {
                    if (errorOnRetrievingCommitPosition != null) {
                        this.takingSnapshot = false;
                        LOG.error("Unexpected error on retrieving commit position", errorOnRetrievingCommitPosition);
                        return;
                    }
                    this.takeSnapshot((long)commitPosition);
                });
            } else {
                LOG.error(ERROR_MSG_ON_RESOLVE_PROCESSED_POS, error);
                this.takingSnapshot = false;
            }
        });
    }

    private void takeSnapshot(long initialCommitPosition) {
        Optional<TransientSnapshot> optionalPendingSnapshot = this.stateController.takeTransientSnapshot(this.lowerBoundSnapshotPosition);
        if (optionalPendingSnapshot.isEmpty()) {
            this.takingSnapshot = false;
            return;
        }
        optionalPendingSnapshot.get().onSnapshotTaken((isValid, snapshotTakenError) -> this.actor.run(() -> {
            if (snapshotTakenError != null) {
                LOG.error("Could not take a snapshot for {}", (Object)this.processorName, snapshotTakenError);
                return;
            }
            LOG.debug("Created pending snapshot for {}", (Object)this.processorName);
            this.pendingSnapshot = (TransientSnapshot)optionalPendingSnapshot.get();
            ActorFuture lastWrittenPosition = this.streamProcessor.getLastWrittenPositionAsync();
            this.actor.runOnCompletion(lastWrittenPosition, (endPosition, error) -> {
                if (error == null) {
                    LOG.info(LOG_MSG_WAIT_UNTIL_COMMITTED, endPosition, (Object)initialCommitPosition);
                    this.lastWrittenEventPosition = endPosition;
                    this.persistingSnapshot = false;
                    this.persistSnapshotIfLastWrittenPositionCommitted();
                } else {
                    this.lastWrittenEventPosition = null;
                    this.takingSnapshot = false;
                    this.pendingSnapshot.abort();
                    this.pendingSnapshot = null;
                    LOG.error(ERROR_MSG_ON_RESOLVE_WRITTEN_POS, error);
                }
            });
        }));
    }

    private void persistSnapshotIfLastWrittenPositionCommitted() {
        this.logStream.getCommitPositionAsync().onComplete((currentCommitPosition, error) -> {
            if (this.pendingSnapshot != null && this.lastWrittenEventPosition != null && currentCommitPosition >= this.lastWrittenEventPosition && !this.persistingSnapshot) {
                this.persistingSnapshot = true;
                ActorFuture snapshotPersistFuture = this.pendingSnapshot.persist();
                snapshotPersistFuture.onComplete((snapshot, persistError) -> {
                    if (persistError != null) {
                        LOG.error(ERROR_MSG_MOVE_SNAPSHOT, persistError);
                    } else {
                        LOG.info("Current commit position {} >= {}, snapshot {} is valid and has been persisted.", new Object[]{currentCommitPosition, this.lastWrittenEventPosition, snapshot.getId()});
                    }
                    this.lastWrittenEventPosition = null;
                    this.takingSnapshot = false;
                    this.pendingSnapshot = null;
                    this.persistingSnapshot = false;
                });
            }
        });
    }
}

