/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl;

import io.atomix.raft.storage.log.IndexedRaftRecord;
import io.atomix.raft.storage.log.RaftLogReader;
import io.zeebe.broker.system.partitions.AtomixRecordEntrySupplier;
import java.util.Optional;

public final class AtomixRecordEntrySupplierImpl
implements AtomixRecordEntrySupplier {
    private final RaftLogReader reader;

    public AtomixRecordEntrySupplierImpl(RaftLogReader reader) {
        this.reader = reader;
    }

    @Override
    public Optional<IndexedRaftRecord> getPreviousIndexedEntry(long position) {
        long recordIndex = this.reader.seekToAsqn(position);
        long prevIndex = recordIndex - 1L;
        if (this.reader.reset(prevIndex) == prevIndex) {
            return Optional.of(this.reader.next());
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

