/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl;

import io.atomix.raft.partition.RaftPartition;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class PartitionProcessingState {
    private static final String PERSISTED_PAUSE_STATE_FILENAME = ".processorPaused";
    private static final String PERSISTED_EXPORTER_PAUSE_STATE_FILENAME = ".exporterPaused";
    private boolean isProcessingPaused;
    private boolean isExportingPaused;
    private final RaftPartition raftPartition;
    private boolean diskSpaceAvailable;

    public PartitionProcessingState(RaftPartition raftPartition) {
        this.raftPartition = raftPartition;
        this.initProcessingStatus();
        this.initExportingState();
    }

    public boolean isDiskSpaceAvailable() {
        return this.diskSpaceAvailable;
    }

    public void setDiskSpaceAvailable(boolean diskSpaceAvailable) {
        this.diskSpaceAvailable = diskSpaceAvailable;
    }

    public boolean isProcessingPaused() {
        return this.isProcessingPaused;
    }

    public void resumeProcessing() throws IOException {
        File persistedPauseState = this.getPersistedPauseState(PERSISTED_PAUSE_STATE_FILENAME);
        Files.deleteIfExists(persistedPauseState.toPath());
        if (!persistedPauseState.exists()) {
            this.isProcessingPaused = false;
        }
    }

    public void pauseProcessing() throws IOException {
        File persistedPauseState = this.getPersistedPauseState(PERSISTED_PAUSE_STATE_FILENAME);
        persistedPauseState.createNewFile();
        if (persistedPauseState.exists()) {
            this.isProcessingPaused = true;
        }
    }

    private File getPersistedPauseState(String filename) {
        return this.raftPartition.dataDirectory().toPath().resolve(filename).toFile();
    }

    private void initProcessingStatus() {
        this.isProcessingPaused = this.getPersistedPauseState(PERSISTED_PAUSE_STATE_FILENAME).exists();
    }

    public boolean shouldProcess() {
        return this.isDiskSpaceAvailable() && !this.isProcessingPaused();
    }

    public boolean isExportingPaused() {
        return this.isExportingPaused;
    }

    public boolean pauseExporting() throws IOException {
        File persistedExporterPauseState = this.getPersistedPauseState(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME);
        persistedExporterPauseState.createNewFile();
        if (persistedExporterPauseState.exists()) {
            this.isExportingPaused = true;
            return true;
        }
        return false;
    }

    public boolean resumeExporting() throws IOException {
        File persistedExporterPauseState = this.getPersistedPauseState(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME);
        Files.deleteIfExists(persistedExporterPauseState.toPath());
        if (!persistedExporterPauseState.exists()) {
            this.isExportingPaused = false;
            return true;
        }
        return false;
    }

    private void initExportingState() {
        this.isExportingPaused = this.getPersistedPauseState(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME).exists();
    }
}

