/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.broker.system.partitions.PartitionTransition;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;

public class PartitionTransitionImpl
implements PartitionTransition {
    private static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private static final List<PartitionStep> EMPTY_LIST = Collections.emptyList();
    private static final int INACTIVE_TERM = -1;
    private final PartitionContext context;
    private final List<PartitionStep> leaderSteps;
    private final List<PartitionStep> followerSteps;
    private final List<PartitionStep> openedSteps = new ArrayList<PartitionStep>();
    private CompletableActorFuture<Void> currentTransition = CompletableActorFuture.completed(null);

    public PartitionTransitionImpl(PartitionContext context, List<PartitionStep> leaderSteps, List<PartitionStep> followerSteps) {
        this.context = context;
        this.leaderSteps = leaderSteps;
        this.followerSteps = followerSteps;
    }

    @Override
    public ActorFuture<Void> toFollower(long currentTerm) {
        return this.enqueueTransition(currentTerm, this.followerSteps);
    }

    @Override
    public ActorFuture<Void> toLeader(long currentTerm) {
        return this.enqueueTransition(currentTerm, this.leaderSteps);
    }

    @Override
    public ActorFuture<Void> toInactive() {
        return this.enqueueTransition(-1L, EMPTY_LIST);
    }

    private ActorFuture<Void> enqueueTransition(long currentTerm, List<PartitionStep> partitionStepList) {
        CompletableActorFuture nextTransitionFuture = new CompletableActorFuture();
        CompletableActorFuture<Void> nextCurrentTransition = this.currentTransition;
        this.currentTransition = nextTransitionFuture;
        nextCurrentTransition.onComplete((nothing, err) -> this.transition(currentTerm, (CompletableActorFuture<Void>)nextTransitionFuture, partitionStepList));
        return nextTransitionFuture;
    }

    private void transition(long currentTerm, CompletableActorFuture<Void> future, List<PartitionStep> steps) {
        this.closePartition().onComplete((nothing, err) -> this.installPartition(currentTerm, future, new ArrayList<PartitionStep>(steps)));
    }

    private void installPartition(long currentTerm, CompletableActorFuture<Void> future, List<PartitionStep> steps) {
        if (steps.isEmpty()) {
            LOG.debug("Partition {} transition complete, installed {} resources!", (Object)this.context.getPartitionId(), (Object)this.openedSteps.size());
            future.complete(null);
            return;
        }
        PartitionStep step = steps.remove(0);
        step.open(currentTerm, this.context).onComplete((value, err) -> {
            if (err != null) {
                LOG.error("Expected to open step '{}' but failed with", (Object)step.getName(), err);
                this.tryCloseStep(step);
                future.completeExceptionally(err);
            } else {
                this.openedSteps.add(step);
                this.installPartition(currentTerm, future, steps);
            }
        });
    }

    private void tryCloseStep(PartitionStep step) {
        try {
            step.close(this.context);
        }
        catch (Exception e) {
            LOG.debug("Couldn't close partition step '{}' that failed to open", (Object)step.getName(), (Object)e);
        }
    }

    private CompletableActorFuture<Void> closePartition() {
        ArrayList<PartitionStep> closingSteps = new ArrayList<PartitionStep>(this.openedSteps);
        Collections.reverse(closingSteps);
        return this.closeSteps(closingSteps);
    }

    private CompletableActorFuture<Void> closeSteps(List<PartitionStep> steps) {
        CompletableActorFuture closingPartitionFuture = new CompletableActorFuture();
        this.stepByStepClosing((CompletableActorFuture<Void>)closingPartitionFuture, steps, null);
        return closingPartitionFuture;
    }

    private void stepByStepClosing(CompletableActorFuture<Void> future, List<PartitionStep> steps, Throwable throwable) {
        if (steps.isEmpty()) {
            LOG.debug("Partition {} closed all previous open resources, before transitioning.", (Object)this.context.getPartitionId());
            if (throwable == null) {
                future.complete(null);
            } else {
                future.completeExceptionally(throwable);
            }
            return;
        }
        PartitionStep step = steps.remove(0);
        LOG.debug("Closing Zeebe-Partition-{}: {}", (Object)this.context.getPartitionId(), (Object)step.getName());
        ActorFuture<Void> closeFuture = step.close(this.context);
        closeFuture.onComplete((v, closingError) -> {
            if (closingError == null) {
                LOG.debug("Closing Zeebe-Partition-{}: {} closed successfully", (Object)this.context.getPartitionId(), (Object)step.getName());
            } else {
                LOG.error("Closing Zeebe-Partition-{}: {} failed to close. Closing remaining steps", new Object[]{this.context.getPartitionId(), step.getName(), closingError});
            }
            this.openedSteps.remove(step);
            this.stepByStepClosing(future, steps, throwable != null ? throwable : closingError);
        });
    }
}

