/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl;

import io.prometheus.client.Gauge;

public class SnapshotReplicationMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String PARTITION_LABEL_NAME = "partition";
    private static final Gauge COUNT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).labelNames(new String[]{"partition"})).help("Count of ongoing snapshot replication")).name("snapshot_replication_count")).register();
    private static final Gauge DURATION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).labelNames(new String[]{"partition"})).help("Approximate duration of replication in milliseconds")).name("snapshot_replication_duration_milliseconds")).register();
    private final String partitionId;

    public SnapshotReplicationMetrics(String partitionId) {
        this.partitionId = partitionId;
    }

    public void incrementCount() {
        ((Gauge.Child)COUNT.labels(new String[]{this.partitionId})).inc();
    }

    public void decrementCount() {
        ((Gauge.Child)COUNT.labels(new String[]{this.partitionId})).dec();
    }

    public void setCount(long value) {
        ((Gauge.Child)COUNT.labels(new String[]{this.partitionId})).set((double)value);
    }

    public void observeDuration(long durationMillis) {
        ((Gauge.Child)DURATION.labels(new String[]{this.partitionId})).set((double)durationMillis);
    }
}

