/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl;

import io.atomix.raft.snapshot.impl.SnapshotChunkImpl;
import io.zeebe.broker.system.partitions.PartitionMessagingService;
import io.zeebe.broker.system.partitions.SnapshotReplication;
import io.zeebe.engine.Loggers;
import io.zeebe.snapshots.raft.SnapshotChunk;
import io.zeebe.util.sched.Actor;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public final class StateReplication
implements SnapshotReplication {
    private static final String REPLICATION_TOPIC_FORMAT = "replication-%d";
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final String replicationTopic;
    private final DirectBuffer readBuffer = new UnsafeBuffer(0L, 0);
    private final PartitionMessagingService messagingService;
    private final String threadName;
    private ExecutorService executorService;

    public StateReplication(PartitionMessagingService messagingService, int partitionId, int nodeId) {
        this.messagingService = messagingService;
        this.replicationTopic = String.format(REPLICATION_TOPIC_FORMAT, partitionId);
        this.threadName = Actor.buildActorName((int)nodeId, (String)"StateReplication", (int)partitionId);
    }

    @Override
    public void replicate(SnapshotChunk chunk) {
        LOG.trace("Replicate on topic {} snapshot chunk {} for snapshot {}.", new Object[]{this.replicationTopic, chunk.getChunkName(), chunk.getSnapshotId()});
        this.messagingService.broadcast(this.replicationTopic, this.serializeSnapshotChunk(chunk));
    }

    @Override
    public void consume(Consumer<SnapshotChunk> consumer) {
        this.executorService = Executors.newSingleThreadExecutor(r -> new Thread(r, this.threadName));
        this.messagingService.subscribe(this.replicationTopic, message -> {
            SnapshotChunk chunk = this.deserializeChunk((ByteBuffer)message);
            LOG.trace("Received on topic {} replicated snapshot chunk {} for snapshot {}.", new Object[]{this.replicationTopic, chunk.getChunkName(), chunk.getSnapshotId()});
            consumer.accept(chunk);
        }, this.executorService);
    }

    @Override
    public void close() throws Exception {
        this.messagingService.unsubscribe(this.replicationTopic);
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            this.executorService = null;
        }
    }

    private ByteBuffer serializeSnapshotChunk(SnapshotChunk chunk) {
        return new SnapshotChunkImpl(chunk).toByteBuffer();
    }

    private SnapshotChunk deserializeChunk(ByteBuffer buffer) {
        SnapshotChunkImpl chunk = new SnapshotChunkImpl();
        this.readBuffer.wrap(buffer);
        chunk.wrap(this.readBuffer, 0, this.readBuffer.capacity());
        return chunk;
    }
}

