/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.logstreams.storage.atomix.AtomixLogStorage;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.Optional;

public class AtomixLogStoragePartitionStep
implements PartitionStep {
    private static final String WRONG_TERM_ERROR_MSG = "Expected that current term '%d' is same as raft term '%d', but was not. Failing installation of 'AtomixLogStoragePartitionStep' on partition %d.";

    @Override
    public ActorFuture<Void> open(long currentTerm, PartitionContext context) {
        CompletableActorFuture openFuture = new CompletableActorFuture();
        RaftPartitionServer server = context.getRaftPartition().getServer();
        Optional appenderOptional = server.getAppender();
        appenderOptional.ifPresentOrElse(logAppender -> {
            long raftTerm = server.getTerm();
            if (raftTerm != currentTerm) {
                openFuture.completeExceptionally((Throwable)new IllegalStateException(String.format(WRONG_TERM_ERROR_MSG, currentTerm, raftTerm, context.getPartitionId())));
            } else {
                context.setAtomixLogStorage(AtomixLogStorage.ofPartition((arg_0, arg_1) -> ((RaftPartitionServer)server).openReader(arg_0, arg_1), (ZeebeLogAppender)logAppender));
                openFuture.complete(null);
            }
        }, () -> openFuture.completeExceptionally((Throwable)new IllegalStateException("Not leader of partition " + context.getPartitionId())));
        return openFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        context.setAtomixLogStorage(null);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "AtomixLogStorage";
    }
}

