/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl.steps;

import io.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.zeebe.broker.exporter.stream.ExporterDirector;
import io.zeebe.broker.exporter.stream.ExporterDirectorContext;
import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.Collection;

public class ExporterDirectorPartitionStep
implements PartitionStep {
    private static final int EXPORTER_PROCESSOR_ID = 1003;

    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        Collection<ExporterDescriptor> exporterDescriptors = context.getExporterRepository().getExporters().values();
        ExporterDirectorContext exporterCtx = new ExporterDirectorContext().id(1003).name(Actor.buildActorName((int)context.getNodeId(), (String)"Exporter", (int)context.getPartitionId())).logStream(context.getLogStream()).zeebeDb(context.getZeebeDb()).descriptors(exporterDescriptors);
        ExporterDirector director = new ExporterDirector(exporterCtx, !context.shouldExport());
        context.setExporterDirector(director);
        ActorFuture<Void> startFuture = director.startAsync(context.getScheduler());
        startFuture.onComplete((nothing, error) -> {
            if (error == null) {
                if (!context.shouldExport()) {
                    director.pauseExporting();
                } else {
                    director.resumeExporting();
                }
            }
        });
        return startFuture;
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        ActorFuture future = context.getExporterDirector().closeAsync();
        context.setExporterDirector(null);
        return future;
    }

    @Override
    public String getName() {
        return "ExporterDirector";
    }
}

