/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl.steps;

import io.atomix.raft.storage.log.RaftLogReader;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;

public class RaftLogReaderPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        RaftLogReader reader = context.getRaftPartition().getServer().openReader(-1L, RaftLogReader.Mode.COMMITS);
        context.setRaftLogReader(reader);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        try {
            context.getRaftLogReader().close();
        }
        catch (Exception e) {
            Loggers.SYSTEM_LOGGER.error("Unexpected error closing Raft log reader for partition {}", (Object)context.getPartitionId(), (Object)e);
        }
        finally {
            context.setRaftLogReader(null);
        }
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "RaftLogReader";
    }
}

