/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl.steps;

import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.broker.system.partitions.impl.AsyncSnapshotDirector;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import java.time.Duration;

public class SnapshotDirectorPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        Duration snapshotPeriod = context.getBrokerCfg().getData().getSnapshotPeriod();
        AsyncSnapshotDirector snapshotDirector = new AsyncSnapshotDirector(context.getNodeId(), context.getStreamProcessor(), context.getSnapshotController(), context.getLogStream(), snapshotPeriod);
        context.setSnapshotDirector(snapshotDirector);
        return context.getScheduler().submitActor((Actor)snapshotDirector);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        ActorFuture<Void> future = context.getSnapshotDirector().closeAsync();
        context.setSnapshotDirector(null);
        return future;
    }

    @Override
    public String getName() {
        return "AsyncSnapshotDirector";
    }
}

