/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl.steps;

import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.engine.processing.streamprocessor.StreamProcessor;
import io.zeebe.engine.state.appliers.EventAppliers;
import io.zeebe.engine.state.mutable.MutableZeebeState;
import io.zeebe.util.health.HealthMonitorable;
import io.zeebe.util.sched.ActorControl;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;

public class StreamProcessorPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        StreamProcessor streamProcessor = this.createStreamProcessor(context);
        ActorFuture openFuture = streamProcessor.openAsync(!context.shouldProcess());
        CompletableActorFuture future = new CompletableActorFuture();
        openFuture.onComplete((nothing, err) -> {
            if (err == null) {
                context.setStreamProcessor(streamProcessor);
                if (!context.shouldProcess()) {
                    streamProcessor.pauseProcessing();
                } else {
                    streamProcessor.resumeProcessing();
                }
                context.getComponentHealthMonitor().registerComponent(streamProcessor.getName(), (HealthMonitorable)streamProcessor);
                future.complete(null);
            } else {
                future.completeExceptionally(err);
            }
        });
        return future;
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        context.getComponentHealthMonitor().removeComponent(context.getStreamProcessor().getName());
        ActorFuture future = context.getStreamProcessor().closeAsync();
        context.setStreamProcessor(null);
        return future;
    }

    @Override
    public String getName() {
        return "StreamProcessor";
    }

    private StreamProcessor createStreamProcessor(PartitionContext state) {
        return StreamProcessor.builder().logStream(state.getLogStream()).actorScheduler(state.getScheduler()).zeebeDb(state.getZeebeDb()).eventApplierFactory(EventAppliers::new).nodeId(state.getNodeId()).commandResponseWriter(state.getCommandApiService().newCommandResponseWriter()).detectReprocessingInconsistency(state.getBrokerCfg().getExperimental().isDetectReprocessingInconsistency()).onProcessedListener(state.getCommandApiService().getOnProcessedListener(state.getPartitionId())).streamProcessorFactory(processingContext -> {
            ActorControl actor = processingContext.getActor();
            MutableZeebeState zeebeState = processingContext.getZeebeState();
            return state.getTypedRecordProcessorsFactory().createTypedStreamProcessor(actor, zeebeState, processingContext);
        }).build();
    }
}

