/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.system.partitions.impl.steps;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.system.partitions.PartitionContext;
import io.zeebe.broker.system.partitions.PartitionStep;
import io.zeebe.db.ZeebeDb;
import io.zeebe.snapshots.raft.PersistedSnapshotListener;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;

public class ZeebeDbPartitionStep
implements PartitionStep {
    @Override
    public ActorFuture<Void> open(PartitionContext context) {
        ZeebeDb zeebeDb;
        context.getSnapshotStoreSupplier().getPersistedSnapshotStore(((Integer)context.getRaftPartition().id().id()).intValue()).addSnapshotListener((PersistedSnapshotListener)context.getSnapshotController());
        try {
            context.getSnapshotController().recover();
            zeebeDb = context.getSnapshotController().openDb();
        }
        catch (Exception e) {
            Loggers.SYSTEM_LOGGER.error("Failed to recover from snapshot", (Throwable)e);
            return CompletableActorFuture.completedExceptionally((Throwable)new IllegalStateException(String.format("Unexpected error occurred while recovering snapshot controller during leader partition install for partition %d", context.getPartitionId()), e));
        }
        context.setZeebeDb(zeebeDb);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public ActorFuture<Void> close(PartitionContext context) {
        context.setZeebeDb(null);
        return CompletableActorFuture.completed(null);
    }

    @Override
    public String getName() {
        return "ZeebeDb";
    }
}

