/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.backpressure;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;

public final class BackpressureMetrics {
    private static final Counter DROPPED_REQUEST_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("dropped_request_count_total")).help("Number of requests dropped due to backpressure")).labelNames(new String[]{"partition"})).register();
    private static final Counter TOTAL_REQUEST_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("received_request_count_total")).help("Number of requests received")).labelNames(new String[]{"partition"})).register();
    private static final Gauge CURRENT_INFLIGHT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_inflight_requests_count")).help("Current number of request inflight")).labelNames(new String[]{"partition"})).register();
    private static final Gauge CURRENT_LIMIT = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("backpressure_requests_limit")).help("Current limit for number of inflight requests")).labelNames(new String[]{"partition"})).register();

    public void dropped(int partitionId) {
        ((Counter.Child)DROPPED_REQUEST_COUNT.labels(new String[]{String.valueOf(partitionId)})).inc();
    }

    public void receivedRequest(int partitionId) {
        ((Counter.Child)TOTAL_REQUEST_COUNT.labels(new String[]{String.valueOf(partitionId)})).inc();
    }

    public void incInflight(int partitionId) {
        ((Gauge.Child)CURRENT_INFLIGHT.labels(new String[]{String.valueOf(partitionId)})).inc();
    }

    public void decInflight(int partitionId) {
        ((Gauge.Child)CURRENT_INFLIGHT.labels(new String[]{String.valueOf(partitionId)})).dec();
    }

    public void setNewLimit(int partitionId, int newLimit) {
        ((Gauge.Child)CURRENT_LIMIT.labels(new String[]{String.valueOf(partitionId)})).set((double)newLimit);
    }

    public void setInflight(int partitionId, int count) {
        ((Gauge.Child)CURRENT_INFLIGHT.labels(new String[]{String.valueOf(partitionId)})).set(0.0);
    }
}

