/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.backpressure;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.zeebe.broker.Loggers;
import io.zeebe.broker.transport.backpressure.BackpressureMetrics;
import io.zeebe.broker.transport.backpressure.RequestLimiter;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.intent.JobIntent;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class CommandRateLimiter
extends AbstractLimiter<Intent>
implements RequestLimiter<Intent> {
    private static final Set<? extends Intent> WHITE_LISTED_COMMANDS = EnumSet.of(JobIntent.COMPLETE, JobIntent.FAIL);
    private final Map<ListenerId, Limiter.Listener> responseListeners = new ConcurrentHashMap<ListenerId, Limiter.Listener>();
    private final int partitionId;
    private final BackpressureMetrics metrics = new BackpressureMetrics();

    protected CommandRateLimiter(CommandRateLimiterBuilder builder, int partitionId) {
        super((AbstractLimiter.Builder)builder);
        this.partitionId = partitionId;
        this.metrics.setInflight(partitionId, 0);
        this.metrics.setNewLimit(partitionId, this.getLimit());
    }

    public Optional<Limiter.Listener> acquire(Intent intent) {
        if (this.getInflight() >= this.getLimit() && !WHITE_LISTED_COMMANDS.contains(intent)) {
            return this.createRejectedListener();
        }
        Limiter.Listener listener = this.createListener();
        return Optional.of(listener);
    }

    private void registerListener(int streamId, long requestId, Limiter.Listener listener) {
        this.responseListeners.put(new ListenerId(streamId, requestId), listener);
    }

    @Override
    public boolean tryAcquire(int streamId, long requestId, Intent context) {
        Optional<Limiter.Listener> acquired = this.acquire(context);
        return acquired.map(listener -> {
            this.registerListener(streamId, requestId, (Limiter.Listener)listener);
            this.metrics.incInflight(this.partitionId);
            return true;
        }).orElse(false);
    }

    @Override
    public void onResponse(int streamId, long requestId) {
        Limiter.Listener listener = this.responseListeners.remove(new ListenerId(streamId, requestId));
        if (listener != null) {
            listener.onSuccess();
            this.metrics.decInflight(this.partitionId);
        } else {
            Loggers.TRANSPORT_LOGGER.debug("Expected to have a rate limiter listener for request-{}-{}, but none found. (This can happen during fail over.)", (Object)streamId, (Object)requestId);
        }
    }

    @Override
    public void onIgnore(int streamId, long requestId) {
        Limiter.Listener listener = this.responseListeners.remove(new ListenerId(streamId, requestId));
        if (listener != null) {
            listener.onIgnore();
            this.metrics.decInflight(this.partitionId);
        }
    }

    @Override
    public int getInflightCount() {
        return this.getInflight();
    }

    protected void onNewLimit(int newLimit) {
        super.onNewLimit(newLimit);
        this.metrics.setNewLimit(this.partitionId, newLimit);
    }

    public static CommandRateLimiterBuilder builder() {
        return new CommandRateLimiterBuilder();
    }

    static class ListenerId {
        private final int streamId;
        private final long requestId;

        ListenerId(int streamId, long requestId) {
            this.streamId = streamId;
            this.requestId = requestId;
        }

        public int hashCode() {
            return Objects.hash(this.streamId, this.requestId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListenerId that = (ListenerId)o;
            return this.streamId == that.streamId && this.requestId == that.requestId;
        }
    }

    public static class CommandRateLimiterBuilder
    extends AbstractLimiter.Builder<CommandRateLimiterBuilder> {
        protected CommandRateLimiterBuilder self() {
            return this;
        }

        public CommandRateLimiter build(int partitionId) {
            return new CommandRateLimiter(this, partitionId);
        }
    }
}

