/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.commandapi;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.transport.backpressure.BackpressureMetrics;
import io.zeebe.broker.transport.backpressure.RequestLimiter;
import io.zeebe.broker.transport.commandapi.ErrorResponseWriter;
import io.zeebe.logstreams.log.LogStreamRecordWriter;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.RecordMetadata;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.zeebe.protocol.record.MessageHeaderDecoder;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.transport.RequestHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.util.buffer.BufferWriter;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.slf4j.Logger;

final class CommandApiRequestHandler
implements RequestHandler {
    private static final Logger LOG = Loggers.TRANSPORT_LOGGER;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ExecuteCommandRequestDecoder executeCommandRequestDecoder = new ExecuteCommandRequestDecoder();
    private final Queue<Runnable> cmdQueue = new ManyToOneConcurrentLinkedQueue();
    private final Consumer<Runnable> cmdConsumer = Runnable::run;
    private final Int2ObjectHashMap<LogStreamRecordWriter> leadingStreams = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<RequestLimiter<Intent>> partitionLimiters = new Int2ObjectHashMap();
    private final RecordMetadata eventMetadata = new RecordMetadata();
    private final ErrorResponseWriter errorResponseWriter = new ErrorResponseWriter();
    private final Map<ValueType, UnpackedObject> recordsByType = new EnumMap<ValueType, UnpackedObject>(ValueType.class);
    private final BackpressureMetrics metrics = new BackpressureMetrics();
    private boolean isDiskSpaceAvailable = true;

    CommandApiRequestHandler() {
        this.initEventTypeMap();
    }

    private void initEventTypeMap() {
        this.recordsByType.put(ValueType.DEPLOYMENT, (UnpackedObject)new DeploymentRecord());
        this.recordsByType.put(ValueType.JOB, (UnpackedObject)new JobRecord());
        this.recordsByType.put(ValueType.PROCESS_INSTANCE, (UnpackedObject)new ProcessInstanceRecord());
        this.recordsByType.put(ValueType.MESSAGE, (UnpackedObject)new MessageRecord());
        this.recordsByType.put(ValueType.JOB_BATCH, (UnpackedObject)new JobBatchRecord());
        this.recordsByType.put(ValueType.INCIDENT, (UnpackedObject)new IncidentRecord());
        this.recordsByType.put(ValueType.VARIABLE_DOCUMENT, (UnpackedObject)new VariableDocumentRecord());
        this.recordsByType.put(ValueType.PROCESS_INSTANCE_CREATION, (UnpackedObject)new ProcessInstanceCreationRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExecuteCommandRequest(ServerOutput output, int partitionId, long requestId, RecordMetadata eventMetadata, DirectBuffer buffer, int messageOffset, int messageLength) {
        if (!this.isDiskSpaceAvailable) {
            this.errorResponseWriter.resourceExhausted(String.format("Cannot accept requests for partition %d. Broker is out of disk space", partitionId)).tryWriteResponse(output, partitionId, requestId);
            return;
        }
        this.executeCommandRequestDecoder.wrap(buffer, messageOffset + this.messageHeaderDecoder.encodedLength(), this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
        long key = this.executeCommandRequestDecoder.key();
        LogStreamRecordWriter logStreamWriter = (LogStreamRecordWriter)this.leadingStreams.get(partitionId);
        if (logStreamWriter == null) {
            this.errorResponseWriter.partitionLeaderMismatch(partitionId).tryWriteResponseOrLogFailure(output, partitionId, requestId);
            return;
        }
        ValueType eventType = this.executeCommandRequestDecoder.valueType();
        short intent = this.executeCommandRequestDecoder.intent();
        UnpackedObject event = this.recordsByType.get(eventType);
        if (event == null) {
            this.errorResponseWriter.unsupportedMessage(eventType.name(), this.recordsByType.keySet().toArray()).tryWriteResponseOrLogFailure(output, partitionId, requestId);
            return;
        }
        int eventOffset = this.executeCommandRequestDecoder.limit() + ExecuteCommandRequestDecoder.valueHeaderLength();
        int eventLength = this.executeCommandRequestDecoder.valueLength();
        event.reset();
        try {
            event.wrap(buffer, eventOffset, eventLength);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to deserialize message of type {} in client API", (Object)eventType.name(), (Object)e);
            this.errorResponseWriter.malformedRequest(e).tryWriteResponseOrLogFailure(output, partitionId, requestId);
            return;
        }
        eventMetadata.recordType(RecordType.COMMAND);
        Intent eventIntent = Intent.fromProtocolValue((ValueType)eventType, (short)intent);
        eventMetadata.intent(eventIntent);
        eventMetadata.valueType(eventType);
        this.metrics.receivedRequest(partitionId);
        RequestLimiter limiter = (RequestLimiter)this.partitionLimiters.get(partitionId);
        if (!limiter.tryAcquire(partitionId, requestId, eventIntent)) {
            this.metrics.dropped(partitionId);
            LOG.trace("Partition-{} receiving too many requests. Current limit {} inflight {}, dropping request {} from gateway", new Object[]{partitionId, limiter.getLimit(), limiter.getInflightCount(), requestId});
            this.errorResponseWriter.resourceExhausted().tryWriteResponse(output, partitionId, requestId);
            return;
        }
        boolean written = false;
        try {
            written = this.writeCommand(eventMetadata, buffer, key, logStreamWriter, eventOffset, eventLength);
        }
        catch (Exception ex) {
            LOG.error("Unexpected error on writing {} command", (Object)eventIntent, (Object)ex);
        }
        finally {
            if (!written) {
                limiter.onIgnore(partitionId, requestId);
            }
        }
    }

    private boolean writeCommand(RecordMetadata eventMetadata, DirectBuffer buffer, long key, LogStreamRecordWriter logStreamWriter, int eventOffset, int eventLength) {
        logStreamWriter.reset();
        if (key != ExecuteCommandRequestDecoder.keyNullValue()) {
            logStreamWriter.key(key);
        } else {
            logStreamWriter.keyNull();
        }
        long eventPosition = logStreamWriter.metadataWriter((BufferWriter)eventMetadata).value(buffer, eventOffset, eventLength).tryWrite();
        return eventPosition >= 0L;
    }

    void addPartition(int partitionId, LogStreamRecordWriter logStreamWriter, RequestLimiter<Intent> limiter) {
        this.cmdQueue.add(() -> {
            this.leadingStreams.put(partitionId, (Object)logStreamWriter);
            this.partitionLimiters.put(partitionId, (Object)limiter);
        });
    }

    void removePartition(int partitionId) {
        this.cmdQueue.add(() -> {
            this.leadingStreams.remove(partitionId);
            this.partitionLimiters.remove(partitionId);
        });
    }

    void onDiskSpaceNotAvailable() {
        this.cmdQueue.add(() -> {
            this.isDiskSpaceAvailable = false;
            LOG.debug("Broker is out of disk space. All client requests will be rejected");
        });
    }

    void onDiskSpaceAvailable() {
        this.cmdQueue.add(() -> {
            this.isDiskSpaceAvailable = true;
        });
    }

    public void onRequest(ServerOutput output, int partitionId, long requestId, DirectBuffer buffer, int offset, int length) {
        this.drainCommandQueue();
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        int clientVersion = this.messageHeaderDecoder.version();
        if (clientVersion > 3) {
            this.errorResponseWriter.invalidClientVersion(3, clientVersion).tryWriteResponse(output, partitionId, requestId);
            return;
        }
        this.eventMetadata.reset();
        this.eventMetadata.protocolVersion(clientVersion);
        this.eventMetadata.requestId(requestId);
        this.eventMetadata.requestStreamId(partitionId);
        if (templateId == 20) {
            this.handleExecuteCommandRequest(output, partitionId, requestId, this.eventMetadata, buffer, offset, length);
            return;
        }
        this.errorResponseWriter.invalidMessageTemplate(templateId, 20).tryWriteResponse(output, partitionId, requestId);
    }

    private void drainCommandQueue() {
        while (!this.cmdQueue.isEmpty()) {
            Runnable runnable = this.cmdQueue.poll();
            if (runnable == null) continue;
            this.cmdConsumer.accept(runnable);
        }
    }
}

