/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.commandapi;

import io.zeebe.broker.Loggers;
import io.zeebe.broker.PartitionListener;
import io.zeebe.broker.system.monitoring.DiskSpaceUsageListener;
import io.zeebe.broker.transport.backpressure.PartitionAwareRequestLimiter;
import io.zeebe.broker.transport.backpressure.RequestLimiter;
import io.zeebe.broker.transport.commandapi.CommandApiRequestHandler;
import io.zeebe.broker.transport.commandapi.CommandResponseWriterImpl;
import io.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.logstreams.log.LogStreamRecordWriter;
import io.zeebe.protocol.impl.encoding.BrokerInfo;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.transport.RequestHandler;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerTransport;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.util.function.Consumer;
import org.agrona.collections.IntHashSet;

public final class CommandApiService
extends Actor
implements PartitionListener,
DiskSpaceUsageListener {
    private final PartitionAwareRequestLimiter limiter;
    private final ServerTransport serverTransport;
    private final CommandApiRequestHandler requestHandler;
    private final IntHashSet leadPartitions = new IntHashSet();
    private final String actorName;

    public CommandApiService(ServerTransport serverTransport, BrokerInfo localBroker, PartitionAwareRequestLimiter limiter) {
        this.serverTransport = serverTransport;
        this.limiter = limiter;
        this.requestHandler = new CommandApiRequestHandler();
        this.actorName = CommandApiService.buildActorName((int)localBroker.getNodeId(), (String)"CommandApiService");
    }

    public String getName() {
        return this.actorName;
    }

    protected void onActorClosing() {
        for (Integer leadPartition : this.leadPartitions) {
            this.removeForPartitionId(leadPartition);
        }
        this.leadPartitions.clear();
    }

    @Override
    public ActorFuture<Void> onBecomingFollower(int partitionId, long term) {
        return this.removeLeaderHandlersAsync(partitionId);
    }

    @Override
    public ActorFuture<Void> onBecomingLeader(int partitionId, long term, LogStream logStream) {
        CompletableActorFuture future = new CompletableActorFuture();
        this.actor.call(() -> {
            this.leadPartitions.add(partitionId);
            this.limiter.addPartition(partitionId);
            logStream.newLogStreamRecordWriter().onComplete((recordWriter, error) -> {
                if (error == null) {
                    RequestLimiter<Intent> requestLimiter = this.limiter.getLimiter(partitionId);
                    this.requestHandler.addPartition(partitionId, (LogStreamRecordWriter)recordWriter, requestLimiter);
                    this.serverTransport.subscribe(partitionId, (RequestHandler)this.requestHandler);
                    future.complete(null);
                } else {
                    Loggers.SYSTEM_LOGGER.error("Error on retrieving write buffer from log stream {}", (Object)partitionId, error);
                    future.completeExceptionally(error);
                }
            });
        });
        return future;
    }

    @Override
    public ActorFuture<Void> onBecomingInactive(int partitionId, long term) {
        return this.removeLeaderHandlersAsync(partitionId);
    }

    private ActorFuture<Void> removeLeaderHandlersAsync(int partitionId) {
        return this.actor.call(() -> {
            this.requestHandler.removePartition(partitionId);
            this.cleanLeadingPartition(partitionId);
        });
    }

    private void cleanLeadingPartition(int partitionId) {
        this.leadPartitions.remove(partitionId);
        this.removeForPartitionId(partitionId);
    }

    private void removeForPartitionId(int partitionId) {
        this.limiter.removePartition(partitionId);
        this.serverTransport.unsubscribe(partitionId);
    }

    public CommandResponseWriter newCommandResponseWriter() {
        return new CommandResponseWriterImpl((ServerOutput)this.serverTransport);
    }

    public Consumer<TypedRecord> getOnProcessedListener(int partitionId) {
        RequestLimiter<Intent> partitionLimiter = this.limiter.getLimiter(partitionId);
        return typedRecord -> {
            if (typedRecord.getRecordType() == RecordType.COMMAND && typedRecord.hasRequestMetadata()) {
                partitionLimiter.onResponse(typedRecord.getRequestStreamId(), typedRecord.getRequestId());
            }
        };
    }

    @Override
    public void onDiskSpaceNotAvailable() {
        this.actor.run(this.requestHandler::onDiskSpaceNotAvailable);
    }

    @Override
    public void onDiskSpaceAvailable() {
        this.actor.run(this.requestHandler::onDiskSpaceAvailable);
    }
}

