/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.broker.transport.commandapi;

import io.zeebe.engine.processing.streamprocessor.writers.CommandResponseWriter;
import io.zeebe.protocol.Protocol;
import io.zeebe.protocol.record.ExecuteCommandResponseEncoder;
import io.zeebe.protocol.record.MessageHeaderEncoder;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.RejectionType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.transport.ServerOutput;
import io.zeebe.transport.ServerResponse;
import io.zeebe.transport.impl.ServerResponseImpl;
import io.zeebe.util.buffer.BufferWriter;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class CommandResponseWriterImpl
implements CommandResponseWriter,
BufferWriter {
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ExecuteCommandResponseEncoder responseEncoder = new ExecuteCommandResponseEncoder();
    private final ServerResponseImpl response = new ServerResponseImpl();
    private final ServerOutput output;
    private final UnsafeBuffer rejectionReason = new UnsafeBuffer(0L, 0);
    private int partitionId = ExecuteCommandResponseEncoder.partitionIdNullValue();
    private long key = ExecuteCommandResponseEncoder.keyNullValue();
    private BufferWriter valueWriter;
    private RecordType recordType = RecordType.NULL_VAL;
    private ValueType valueType = ValueType.NULL_VAL;
    private short intent = (short)255;
    private RejectionType rejectionType = RejectionType.NULL_VAL;

    public CommandResponseWriterImpl(ServerOutput output) {
        this.output = output;
    }

    public CommandResponseWriterImpl partitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public CommandResponseWriterImpl key(long key) {
        this.key = key;
        return this;
    }

    public CommandResponseWriterImpl intent(Intent intent) {
        this.intent = intent.value();
        return this;
    }

    public CommandResponseWriterImpl recordType(RecordType recordType) {
        this.recordType = recordType;
        return this;
    }

    public CommandResponseWriterImpl valueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public CommandResponseWriterImpl rejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public CommandResponseWriterImpl rejectionReason(DirectBuffer rejectionReason) {
        this.rejectionReason.wrap(rejectionReason);
        return this;
    }

    public CommandResponseWriterImpl valueWriter(BufferWriter writer) {
        this.valueWriter = writer;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryWriteResponse(int remoteStreamId, long requestId) {
        Objects.requireNonNull(this.valueWriter);
        try {
            this.response.reset().setPartitionId(remoteStreamId).setRequestId(requestId).writer((BufferWriter)this);
            this.output.sendResponse((ServerResponse)this.response);
        }
        finally {
            this.reset();
        }
        return true;
    }

    public int getLength() {
        return 22 + ExecuteCommandResponseEncoder.valueHeaderLength() + this.valueWriter.getLength() + ExecuteCommandResponseEncoder.rejectionReasonHeaderLength() + this.rejectionReason.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.messageHeaderEncoder.wrap(buffer, offset).blockLength(this.responseEncoder.sbeBlockLength()).templateId(this.responseEncoder.sbeTemplateId()).schemaId(this.responseEncoder.sbeSchemaId()).version(this.responseEncoder.sbeSchemaVersion());
        this.responseEncoder.wrap(buffer, offset += this.messageHeaderEncoder.encodedLength()).recordType(this.recordType).partitionId(this.partitionId).valueType(this.valueType).intent(this.intent).key(this.key).rejectionType(this.rejectionType);
        offset = this.responseEncoder.limit();
        int eventLength = this.valueWriter.getLength();
        buffer.putInt(offset, eventLength, Protocol.ENDIANNESS);
        this.valueWriter.write(buffer, offset += ExecuteCommandResponseEncoder.valueHeaderLength());
        this.responseEncoder.limit(offset += eventLength);
        this.responseEncoder.putRejectionReason((DirectBuffer)this.rejectionReason, 0, this.rejectionReason.capacity());
    }

    private void reset() {
        this.partitionId = ExecuteCommandResponseEncoder.partitionIdNullValue();
        this.key = ExecuteCommandResponseEncoder.keyNullValue();
        this.valueWriter = null;
        this.recordType = RecordType.NULL_VAL;
        this.intent = (short)255;
        this.valueType = ValueType.NULL_VAL;
        this.rejectionType = RejectionType.NULL_VAL;
        this.rejectionReason.wrap(0L, 0);
    }
}

