/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.clustering.management;

import io.zeebe.clustering.management.ErrorResponseCode;
import io.zeebe.clustering.management.MetaAttribute;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class ErrorResponseDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 1;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 5;
    public static final int SCHEMA_VERSION = 2;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ErrorResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 1;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 5;
    }

    public int sbeSchemaVersion() {
        return 2;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ErrorResponseDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int codeId() {
        return 0;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 0;
    }

    public static int codeEncodingLength() {
        return 1;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short codeRaw() {
        return (short)(this.buffer.getByte(this.offset + 0) & 0xFF);
    }

    public ErrorResponseCode code() {
        return ErrorResponseCode.get((short)(this.buffer.getByte(this.offset + 0) & 0xFF));
    }

    public static int dataId() {
        return 1;
    }

    public static int dataSinceVersion() {
        return 0;
    }

    public static String dataCharacterEncoding() {
        return "UTF-8";
    }

    public static String dataMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int dataHeaderLength() {
        return 4;
    }

    public int dataLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int skipData() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getData(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getData(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapData(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String data() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        ErrorResponseDecoder decoder = new ErrorResponseDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[ErrorResponse](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(5);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 2) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(2);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 1) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(1);
        builder.append("):");
        builder.append("code=");
        builder.append((Object)this.code());
        builder.append('|');
        builder.append("data=");
        builder.append('\'').append(this.data()).append('\'');
        this.limit(originalLimit);
        return builder;
    }
}

