/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log;

import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public class AppenderMetrics {
    private static final Gauge LAST_COMMITTED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_committed_position")).help("The last committed position.")).labelNames(new String[]{"partition"})).register();
    private static final Gauge LAST_APPENDED_POSITION = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("log_appender_last_appended_position")).help("The last appended position by the appender.")).labelNames(new String[]{"partition"})).register();
    private static final Histogram WRITE_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_append_latency")).help("Latency to append an event to the log in seconds")).labelNames(new String[]{"partition"})).register();
    private static final Histogram COMMIT_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("log_appender_commit_latency")).help("Latency to commit an event to the log in seconds")).labelNames(new String[]{"partition"})).register();
    private final String partitionLabel;

    public AppenderMetrics(String partitionLabel) {
        this.partitionLabel = partitionLabel;
    }

    public void setLastCommittedPosition(long position) {
        ((Gauge.Child)LAST_COMMITTED_POSITION.labels(new String[]{this.partitionLabel})).set((double)position);
    }

    public void setLastAppendedPosition(long position) {
        ((Gauge.Child)LAST_APPENDED_POSITION.labels(new String[]{this.partitionLabel})).set((double)position);
    }

    public void appendLatency(long startTime, long currentTime) {
        ((Histogram.Child)WRITE_LATENCY.labels(new String[]{this.partitionLabel})).observe((double)((float)(currentTime - startTime) / 1000.0f));
    }

    public void commitLatency(long startTime, long currentTime) {
        ((Histogram.Child)COMMIT_LATENCY.labels(new String[]{this.partitionLabel})).observe((double)((float)(currentTime - startTime) / 1000.0f));
    }
}

