/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.logstreams.impl.log;

import com.netflix.concurrency.limits.Limit;
import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.WindowedLimit;
import io.zeebe.dispatcher.BlockPeek;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.logstreams.impl.Loggers;
import io.zeebe.logstreams.impl.backpressure.AlgorithmCfg;
import io.zeebe.logstreams.impl.backpressure.AppendBackpressureMetrics;
import io.zeebe.logstreams.impl.backpressure.AppendEntryLimiter;
import io.zeebe.logstreams.impl.backpressure.AppendLimiter;
import io.zeebe.logstreams.impl.backpressure.AppenderGradient2Cfg;
import io.zeebe.logstreams.impl.backpressure.AppenderVegasCfg;
import io.zeebe.logstreams.impl.backpressure.NoopAppendLimiter;
import io.zeebe.logstreams.impl.log.AppenderMetrics;
import io.zeebe.logstreams.impl.log.Listener;
import io.zeebe.logstreams.impl.log.LoggedEventImpl;
import io.zeebe.logstreams.storage.LogStorage;
import io.zeebe.util.Environment;
import io.zeebe.util.collection.Tuple;
import io.zeebe.util.health.FailureListener;
import io.zeebe.util.health.HealthMonitorable;
import io.zeebe.util.health.HealthStatus;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.channel.ConsumableChannel;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.LongConsumer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.slf4j.Logger;

public class LogStorageAppender
extends Actor
implements HealthMonitorable {
    public static final Logger LOG = Loggers.LOGSTREAMS_LOGGER;
    private static final Map<String, AlgorithmCfg> ALGORITHM_CFG = Map.of("vegas", new AppenderVegasCfg(), "gradient2", new AppenderGradient2Cfg());
    private final String name;
    private final Subscription writeBufferSubscription;
    private final int maxAppendBlockSize;
    private final LogStorage logStorage;
    private final AppendLimiter appendEntryLimiter;
    private final AppendBackpressureMetrics appendBackpressureMetrics;
    private final Environment env;
    private final LoggedEventImpl positionReader = new LoggedEventImpl();
    private final AppenderMetrics appenderMetrics;
    private FailureListener failureListener;
    private final ActorFuture<Void> closeFuture;
    private final LongConsumer commitPositionListener;

    public LogStorageAppender(String name, int partitionId, LogStorage logStorage, Subscription writeBufferSubscription, int maxBlockSize, LongConsumer commitPositionListener) {
        this.appenderMetrics = new AppenderMetrics(Integer.toString(partitionId));
        this.commitPositionListener = commitPositionListener;
        this.env = new Environment();
        this.name = name;
        this.logStorage = logStorage;
        this.writeBufferSubscription = writeBufferSubscription;
        this.maxAppendBlockSize = maxBlockSize;
        this.appendBackpressureMetrics = new AppendBackpressureMetrics(partitionId);
        boolean isBackpressureEnabled = this.env.getBool("ZEEBE_BP_APPENDER").orElse(true);
        this.appendEntryLimiter = isBackpressureEnabled ? this.initBackpressure(partitionId) : this.initNoBackpressure(partitionId);
        this.closeFuture = new CompletableActorFuture();
    }

    private AppendLimiter initBackpressure(int partitionId) {
        String algorithmName = this.env.get("ZEEBE_BP_APPENDER_ALGORITHM").orElse("vegas").toLowerCase();
        AlgorithmCfg algorithmCfg = ALGORITHM_CFG.getOrDefault(algorithmName, new AppenderVegasCfg());
        algorithmCfg.applyEnvironment(this.env);
        AbstractLimit abstractLimit = (AbstractLimit)algorithmCfg.get();
        boolean windowedLimiter = this.env.getBool("ZEEBE_BP_APPENDER_WINDOWED").orElse(false);
        LOG.debug("Configured log appender back pressure at partition {} as {}. Window limiting is {}", new Object[]{partitionId, algorithmCfg, windowedLimiter ? "enabled" : "disabled"});
        return ((AppendEntryLimiter.AppendEntryLimiterBuilder)AppendEntryLimiter.builder().limit((Limit)(windowedLimiter ? WindowedLimit.newBuilder().build((Limit)abstractLimit) : abstractLimit))).partitionId(partitionId).build();
    }

    private AppendLimiter initNoBackpressure(int partition) {
        LOG.warn("No back pressure for the log appender (partition = {}) configured! This might cause problems.", (Object)partition);
        return new NoopAppendLimiter();
    }

    private void appendBlock(BlockPeek blockPeek) {
        ByteBuffer rawBuffer = blockPeek.getRawBuffer();
        int bytes = rawBuffer.remaining();
        ByteBuffer copiedBuffer = ByteBuffer.allocate(bytes).put(rawBuffer).flip();
        Tuple<Long, Long> positions = this.readLowestHighestPosition(copiedBuffer);
        this.appendBackpressureMetrics.newEntryToAppend();
        if (this.appendEntryLimiter.tryAcquire((Long)positions.getRight())) {
            Listener listener = new Listener(this, (Long)positions.getRight(), ActorClock.currentTimeMillis());
            this.logStorage.append((Long)positions.getLeft(), (Long)positions.getRight(), copiedBuffer, listener);
            blockPeek.markCompleted();
        } else {
            this.appendBackpressureMetrics.deferred();
            LOG.trace("Backpressure happens: in flight {} limit {}", (Object)this.appendEntryLimiter.getInflight(), (Object)this.appendEntryLimiter.getLimit());
        }
    }

    public String getName() {
        return this.name;
    }

    protected void onActorStarting() {
        this.actor.consume((ConsumableChannel)this.writeBufferSubscription, this::onWriteBufferAvailable);
    }

    protected void onActorClosed() {
        this.closeFuture.complete(null);
    }

    public ActorFuture<Void> closeAsync() {
        if (this.actor.isClosed()) {
            return this.closeFuture;
        }
        super.closeAsync();
        return this.closeFuture;
    }

    protected void handleFailure(Exception failure) {
        this.onFailure(failure);
    }

    public void onActorFailed() {
        this.closeFuture.complete(null);
    }

    private void onWriteBufferAvailable() {
        BlockPeek blockPeek = new BlockPeek();
        if (this.writeBufferSubscription.peekBlock(blockPeek, this.maxAppendBlockSize, true) > 0) {
            this.appendBlock(blockPeek);
        } else {
            this.actor.yield();
        }
    }

    private Tuple<Long, Long> readLowestHighestPosition(ByteBuffer buffer) {
        UnsafeBuffer view = new UnsafeBuffer(buffer);
        Tuple positions = new Tuple((Object)Long.MAX_VALUE, (Object)Long.MIN_VALUE);
        int offset = 0;
        do {
            this.positionReader.wrap((DirectBuffer)view, offset);
            long pos = this.positionReader.getPosition();
            positions.setLeft((Object)Math.min((Long)positions.getLeft(), pos));
            positions.setRight((Object)Math.max((Long)positions.getRight(), pos));
        } while ((offset += this.positionReader.getLength()) < view.capacity());
        return positions;
    }

    public HealthStatus getHealthStatus() {
        return this.actor.isClosed() ? HealthStatus.UNHEALTHY : HealthStatus.HEALTHY;
    }

    public void addFailureListener(FailureListener failureListener) {
        this.actor.run(() -> {
            this.failureListener = failureListener;
        });
    }

    private void onFailure(Throwable error) {
        LOG.error("Actor {} failed in phase {}.", new Object[]{this.name, this.actor.getLifecyclePhase(), error});
        this.actor.fail();
        if (this.failureListener != null) {
            this.failureListener.onFailure();
        }
    }

    void runOnFailure(Throwable error) {
        this.actor.run(() -> this.onFailure(error));
    }

    void releaseBackPressure(long highestPosition) {
        this.actor.run(() -> this.appendEntryLimiter.onCommit(highestPosition));
    }

    void notifyWritePosition(long highestPosition, long startTime) {
        this.actor.run(() -> {
            this.appenderMetrics.setLastAppendedPosition(highestPosition);
            this.appenderMetrics.appendLatency(startTime, ActorClock.currentTimeMillis());
        });
    }

    void notifyCommitPosition(long highestPosition, long startTime) {
        this.actor.run(() -> {
            this.commitPositionListener.accept(highestPosition);
            this.appenderMetrics.setLastCommittedPosition(highestPosition);
            this.appenderMetrics.commitLatency(startTime, ActorClock.currentTimeMillis());
        });
    }
}

